/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTransactionSynchronizationAdapterBuilder;
import org.springframework.data.solr.core.mapping.SimpleSolrMappingContext;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleFilterQuery;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SolrPageRequest;
import org.springframework.data.solr.repository.SolrCrudRepository;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.support.SolrEntityInformationCreatorImpl;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SimpleSolrRepository<T, ID extends Serializable>
implements SolrCrudRepository<T, ID> {
    private static final String DEFAULT_ID_FIELD = "id";
    private final SolrOperations solrOperations;
    private String idFieldName = "id";
    private final Class<T> entityClass;
    private final String solrCollectionName;
    private final SolrEntityInformation<T, ?> entityInformation;

    public SimpleSolrRepository(SolrOperations solrOperations, SolrEntityInformation<T, ?> metadata) {
        Assert.notNull(metadata, (String)"Metadata must not be null!");
        this.solrOperations = solrOperations;
        this.entityInformation = metadata;
        this.entityClass = this.entityInformation.getJavaType();
        this.idFieldName = this.entityInformation.getIdAttribute();
        this.solrCollectionName = this.entityInformation.getCollectionName();
    }

    public SimpleSolrRepository(SolrOperations solrOperations, Class<T> entityClass) {
        this(solrOperations, SimpleSolrRepository.getEntityInformation(entityClass));
    }

    private static SolrEntityInformation getEntityInformation(Class type) {
        return new SolrEntityInformationCreatorImpl((MappingContext<? extends SolrPersistentEntity<?>, SolrPersistentProperty>)new SimpleSolrMappingContext()).getEntityInformation(type);
    }

    public Optional<T> findById(ID id) {
        return this.getSolrOperations().queryForObject(this.solrCollectionName, new SimpleQuery(new Criteria(this.idFieldName).is((Object)id)), this.getEntityClass());
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll(new SolrPageRequest(0, itemCount));
    }

    public Page<T> findAll(Pageable pageable) {
        return this.getSolrOperations().queryForPage(this.solrCollectionName, (Query)new SimpleQuery(new Criteria("*").expression("*")).setPageRequest(pageable), this.getEntityClass());
    }

    public Iterable<T> findAll(Sort sort) {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.getSolrOperations().queryForPage(this.solrCollectionName, (Query)new SimpleQuery(new Criteria("*").expression("*")).setPageRequest(new SolrPageRequest(0, itemCount)).addSort(sort), this.getEntityClass());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        SimpleQuery query = new SimpleQuery((Criteria)new Criteria(this.idFieldName).in((Iterable)ids));
        query.setPageRequest(new SolrPageRequest(0, (int)this.count(query)));
        return this.getSolrOperations().queryForPage(this.solrCollectionName, query, this.getEntityClass());
    }

    @Override
    public long count() {
        return this.count(new SimpleQuery(new Criteria("*").expression("*")));
    }

    protected long count(Query query) {
        Query countQuery = SimpleQuery.fromQuery(query);
        return this.getSolrOperations().count(this.solrCollectionName, countQuery);
    }

    public <S extends T> S save(S entity) {
        return this.save(entity, Duration.ZERO);
    }

    @Override
    public <S extends T> S save(S entity, Duration commitWithin) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.getSolrOperations().saveBean(this.solrCollectionName, entity, commitWithin);
        this.commitIfTransactionSynchronisationIsInactive();
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return this.saveAll(entities, Duration.ZERO);
    }

    @Override
    public <S extends T> Iterable<S> saveAll(Iterable<S> entities, Duration commitWithin) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        if (!(entities instanceof Collection)) {
            throw new InvalidDataAccessApiUsageException("Entities have to be inside a collection");
        }
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.saveBeans(this.solrCollectionName, (Collection)entities, commitWithin);
        this.commitIfTransactionSynchronisationIsInactive();
        return entities;
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.deleteByIds(this.solrCollectionName, id.toString());
        this.commitIfTransactionSynchronisationIsInactive();
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.deleteAll(Collections.singletonList(entity));
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        ArrayList<String> idsToDelete = new ArrayList<String>();
        for (T entity : entities) {
            idsToDelete.add(this.extractIdFromBean(entity).toString());
        }
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.deleteByIds(this.solrCollectionName, idsToDelete);
        this.commitIfTransactionSynchronisationIsInactive();
    }

    public void deleteAll() {
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.delete(this.solrCollectionName, new SimpleFilterQuery(new Criteria("*").expression("*")));
        this.commitIfTransactionSynchronisationIsInactive();
    }

    public final String getIdFieldName() {
        return this.idFieldName;
    }

    public Class<T> getEntityClass() {
        if (!this.isEntityClassSet()) {
            throw new InvalidDataAccessApiUsageException("Unable to resolve EntityClass. Please use according setter!");
        }
        return this.entityClass;
    }

    private boolean isEntityClassSet() {
        return this.entityClass != null;
    }

    public final SolrOperations getSolrOperations() {
        return this.solrOperations;
    }

    private Object extractIdFromBean(T entity) {
        if (this.entityInformation != null) {
            return this.entityInformation.getRequiredId(entity);
        }
        SolrInputDocument solrInputDocument = this.solrOperations.convertBeanToSolrInputDocument(entity);
        return this.extractIdFromSolrInputDocument(solrInputDocument);
    }

    private String extractIdFromSolrInputDocument(SolrInputDocument solrInputDocument) {
        Assert.notNull((Object)solrInputDocument.getField(this.idFieldName), (String)("Unable to find field '" + this.idFieldName + "' in SolrDocument."));
        Assert.notNull((Object)solrInputDocument.getField(this.idFieldName).getValue(), (String)"ID must not be 'null'.");
        return solrInputDocument.getField(this.idFieldName).getValue().toString();
    }

    private void registerTransactionSynchronisationIfSynchronisationActive() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.registerTransactionSynchronisationAdapter();
        }
    }

    private void registerTransactionSynchronisationAdapter() {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)SolrTransactionSynchronizationAdapterBuilder.forOperations(this.solrOperations).onCollection(this.solrCollectionName).withDefaultBehaviour());
    }

    private void commitIfTransactionSynchronisationIsInactive() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            this.solrOperations.commit(this.solrCollectionName);
        }
    }
}

