/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.Assert;

public final class DateTimeConverters {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
    private static final DateTimeFormatter FORMATTER_WITHOUT_MILLIS = ISODateTimeFormat.dateTimeNoMillis().withZoneUTC();

    @WritingConverter
    public static enum JavaDateConverter implements Converter<Date, String>
    {
        INSTANCE;


        public String convert(Date source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return ClientUtils.escapeQueryChars((String)FORMATTER.print(source.getTime()));
        }
    }

    @ReadingConverter
    public static enum DateToLocalDateTimeConverter implements Converter<Date, LocalDateTime>
    {
        INSTANCE;


        public LocalDateTime convert(Date source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return new LocalDateTime(source.getTime());
        }
    }

    @WritingConverter
    public static enum JodaLocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        public Date convert(LocalDateTime source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return source.toDate();
        }
    }

    @WritingConverter
    public static enum JodaLocalDateTimeConverter implements Converter<LocalDateTime, String>
    {
        INSTANCE;


        public String convert(LocalDateTime source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return ClientUtils.escapeQueryChars((String)FORMATTER.print(source.toDateTime(DateTimeZone.UTC).getMillis()));
        }
    }

    @WritingConverter
    public static enum JodaDateTimeToDateConverter implements Converter<DateTime, Date>
    {
        INSTANCE;


        public Date convert(DateTime source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return source.toDate();
        }
    }

    @ReadingConverter
    public static enum DateToJodaDateTimeConverter implements Converter<Date, DateTime>
    {
        INSTANCE;


        public DateTime convert(Date source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return new DateTime(source.getTime());
        }
    }

    @ReadingConverter
    public static enum StringToJodaDateTimeConverter implements Converter<String, DateTime>
    {
        INSTANCE;


        public DateTime convert(String source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return DateTime.parse((String)source, (DateTimeFormatter)FORMATTER_WITHOUT_MILLIS);
        }
    }

    @WritingConverter
    public static enum JodaDateTimeConverter implements Converter<ReadableInstant, String>
    {
        INSTANCE;


        public String convert(ReadableInstant source) {
            Assert.notNull((Object)source, (String)"Source must not be null!");
            return ClientUtils.escapeQueryChars((String)FORMATTER.print(source.getMillis()));
        }
    }
}

