/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.solr.repository.query.BindableSolrParameter;
import org.springframework.data.solr.repository.query.SolrParameter;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrParameters;
import org.springframework.data.solr.repository.query.SolrQueryMethod;

public class SolrParametersParameterAccessor
implements SolrParameterAccessor {
    private final SolrParameters parameters;
    private final ParametersParameterAccessor parametersParameterAccessorDelegate;

    public SolrParametersParameterAccessor(SolrQueryMethod solrQueryMethod, Object[] values) {
        this.parameters = solrQueryMethod.getParameters();
        this.parametersParameterAccessorDelegate = new ParametersParameterAccessor((Parameters)this.parameters, (Object[])values.clone());
    }

    @Override
    public float getBoost(int index) {
        return ((SolrParameter)this.parameters.getBindableParameter(index)).getBoost();
    }

    public Pageable getPageable() {
        return this.parametersParameterAccessorDelegate.getPageable();
    }

    public Sort getSort() {
        return this.parametersParameterAccessorDelegate.getSort();
    }

    public Object getBindableValue(int index) {
        return this.parametersParameterAccessorDelegate.getBindableValue(index);
    }

    public boolean hasBindableNullValue() {
        return this.parametersParameterAccessorDelegate.hasBindableNullValue();
    }

    public Iterator<Object> iterator() {
        return new BindableSolrParameterIterator((Iterator<Object>)this.parametersParameterAccessorDelegate.iterator());
    }

    public Optional<Class<?>> getDynamicProjection() {
        return this.parametersParameterAccessorDelegate.getDynamicProjection();
    }

    public class BindableSolrParameterIterator
    implements Iterator<Object> {
        private final Iterator<Object> delegate;
        private int currentIndex = 0;

        public BindableSolrParameterIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public BindableSolrParameter next() {
            BindableSolrParameter solrParameter = new BindableSolrParameter(this.currentIndex, this.delegate.next());
            solrParameter.setBoost(((SolrParameter)SolrParametersParameterAccessor.this.parameters.getBindableParameter(this.currentIndex)).getBoost());
            ++this.currentIndex;
            return solrParameter;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

