/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.util.Assert;

public class TermFrequencyFunction
extends AbstractFunction {
    private static final String OPERATION = "termfreq";

    private TermFrequencyFunction(String fieldname, String term) {
        super(Arrays.asList(fieldname, term));
    }

    public static Builder termFequency(String term) {
        return new Builder(term);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private final String term;

        public Builder(String term) {
            this.term = term;
        }

        public TermFrequencyFunction inField(String fieldname) {
            Assert.hasText((String)fieldname, (String)"Fieldname for termfrequency must not be 'empty'.");
            return new TermFrequencyFunction(fieldname, this.term);
        }

        public TermFrequencyFunction inField(Field field) {
            Assert.notNull((Object)field, (String)"Field for termfrequency must not be 'null'.");
            return this.inField(field.getName());
        }
    }
}

