/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.common.util.NamedList;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.util.StreamUtils;

public class MappingJacksonResponseParser
extends ResponseParser {
    private static final String WRITER = "json";
    private final MimeType responseType;

    public MappingJacksonResponseParser() {
        this(MappingJacksonResponseParser.defaultMimeType());
    }

    public MappingJacksonResponseParser(MimeType responseType) {
        this.responseType = responseType != null ? responseType : MappingJacksonResponseParser.defaultMimeType();
    }

    public String getWriterType() {
        return WRITER;
    }

    public String getContentType() {
        return this.responseType.toString();
    }

    public String getVersion() {
        return super.getVersion();
    }

    public NamedList<Object> processResponse(InputStream body, String encoding) {
        NamedList result = new NamedList();
        try {
            result.add(WRITER, (Object)StreamUtils.copyToString((InputStream)body, (Charset)Charset.forName(encoding)));
        }
        catch (IOException e) {
            throw new InvalidDataAccessResourceUsageException("Unable to read json from stream.", (Throwable)e);
        }
        return result;
    }

    public NamedList<Object> processResponse(Reader reader) {
        throw new UnsupportedOperationException();
    }

    private static MimeType defaultMimeType() {
        try {
            return new MimeType("application", WRITER);
        }
        catch (MimeTypeParseException o_O) {
            throw new IllegalArgumentException(o_O);
        }
    }
}

