/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.solr.server.support.HttpSolrServerFactory;
import org.springframework.util.Assert;

public class HttpSolrServerFactoryBean
extends HttpSolrServerFactory
implements FactoryBean<SolrServer>,
InitializingBean,
DisposableBean {
    private static final String SERVER_URL_SEPARATOR = ",";
    private String url;
    private Integer timeout;
    private Integer maxConnections;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.url);
        this.initSolrServer();
    }

    private void initSolrServer() {
        if (this.url.contains(SERVER_URL_SEPARATOR)) {
            this.createLoadBalancedHttpSolrServer();
        } else {
            this.createHttpSolrServer();
        }
    }

    private void createHttpSolrServer() {
        HttpSolrServer httpSolrServer = new HttpSolrServer(this.url);
        if (this.timeout != null) {
            httpSolrServer.setConnectionTimeout(this.timeout.intValue());
        }
        if (this.maxConnections != null) {
            httpSolrServer.setMaxTotalConnections(this.maxConnections.intValue());
        }
        this.setSolrServer((SolrServer)httpSolrServer);
    }

    private void createLoadBalancedHttpSolrServer() {
        try {
            LBHttpSolrServer lbHttpSolrServer = new LBHttpSolrServer(StringUtils.split((String)this.url, (String)SERVER_URL_SEPARATOR));
            if (this.timeout != null) {
                lbHttpSolrServer.setConnectionTimeout(this.timeout.intValue());
            }
            this.setSolrServer((SolrServer)lbHttpSolrServer);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to create Load Balanced Http Solr Server", e);
        }
    }

    public SolrServer getObject() throws Exception {
        return this.getSolrServer();
    }

    public Class<?> getObjectType() {
        if (this.getSolrServer() == null) {
            return HttpSolrServer.class;
        }
        return this.getSolrServer().getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }
}

