/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.SolrTransactionSynchronizationAdapterBuilder;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleFilterQuery;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SolrPageRequest;
import org.springframework.data.solr.repository.SolrCrudRepository;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SimpleSolrRepository<T, ID extends Serializable>
implements SolrCrudRepository<T, ID> {
    private static final String DEFAULT_ID_FIELD = "id";
    private SolrOperations solrOperations;
    private String idFieldName = "id";
    private Class<T> entityClass;
    private SolrEntityInformation<T, ?> entityInformation;

    public SimpleSolrRepository() {
    }

    public SimpleSolrRepository(SolrOperations solrOperations) {
        Assert.notNull((Object)solrOperations);
        this.setSolrOperations(solrOperations);
    }

    public SimpleSolrRepository(SolrEntityInformation<T, ?> metadata, SolrOperations solrOperations) {
        this(solrOperations);
        Assert.notNull(metadata);
        this.entityInformation = metadata;
        this.setIdFieldName(this.entityInformation.getIdAttribute());
        this.setEntityClass(this.entityInformation.getJavaType());
    }

    public SimpleSolrRepository(SolrOperations solrOperations, Class<T> entityClass) {
        this(solrOperations);
        this.setEntityClass(entityClass);
    }

    public T findOne(ID id) {
        return this.getSolrOperations().queryForObject(new SimpleQuery(new Criteria(this.idFieldName).is((Object)id)), this.getEntityClass());
    }

    public Iterable<T> findAll() {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.findAll(new SolrPageRequest(0, itemCount));
    }

    public Page<T> findAll(Pageable pageable) {
        return this.getSolrOperations().queryForPage((Query)new SimpleQuery(new Criteria("*").expression("*")).setPageRequest(pageable), this.getEntityClass());
    }

    public Iterable<T> findAll(Sort sort) {
        int itemCount = (int)this.count();
        if (itemCount == 0) {
            return new PageImpl(Collections.emptyList());
        }
        return this.getSolrOperations().queryForPage((Query)new SimpleQuery(new Criteria("*").expression("*")).setPageRequest(new SolrPageRequest(0, itemCount)).addSort(sort), this.getEntityClass());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        SimpleQuery query = new SimpleQuery((Criteria)new Criteria(this.idFieldName).in((Iterable)ids));
        query.setPageRequest(new SolrPageRequest(0, (int)this.count(query)));
        return this.getSolrOperations().queryForPage(query, this.getEntityClass());
    }

    @Override
    public long count() {
        return this.count(new SimpleQuery(new Criteria("*").expression("*")));
    }

    protected long count(Query query) {
        Query countQuery = SimpleQuery.fromQuery(query);
        return this.getSolrOperations().count(countQuery);
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Cannot save 'null' entity.");
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.saveBean(entity);
        this.commitIfTransactionSynchronisationIsInactive();
        return entity;
    }

    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Cannot insert 'null' as a List.");
        if (!(entities instanceof Collection)) {
            throw new InvalidDataAccessApiUsageException("Entities have to be inside a collection");
        }
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.saveBeans((Collection)entities);
        this.commitIfTransactionSynchronisationIsInactive();
        return entities;
    }

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public void delete(ID id) {
        Assert.notNull(id, (String)"Cannot delete entity with id 'null'.");
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.deleteById(id.toString());
        this.commitIfTransactionSynchronisationIsInactive();
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"Cannot delete 'null' entity.");
        this.delete((Iterable<? extends T>)Arrays.asList(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Cannot delete 'null' list.");
        ArrayList<String> idsToDelete = new ArrayList<String>();
        for (T entity : entities) {
            idsToDelete.add(this.extractIdFromBean(entity).toString());
        }
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.deleteById(idsToDelete);
        this.commitIfTransactionSynchronisationIsInactive();
    }

    public void deleteAll() {
        this.registerTransactionSynchronisationIfSynchronisationActive();
        this.solrOperations.delete(new SimpleFilterQuery(new Criteria("*").expression("*")));
        this.commitIfTransactionSynchronisationIsInactive();
    }

    public final String getIdFieldName() {
        return this.idFieldName;
    }

    public final void setIdFieldName(String idFieldName) {
        Assert.notNull((Object)idFieldName, (String)"ID Field cannot be null.");
        this.idFieldName = idFieldName;
    }

    private Class<T> resolveReturnedClassFromGernericType() {
        ParameterizedType parameterizedType = this.resolveReturnedClassFromGernericType(this.getClass());
        return (Class)parameterizedType.getActualTypeArguments()[0];
    }

    private ParameterizedType resolveReturnedClassFromGernericType(Class<?> clazz) {
        ParameterizedType parameterizedType;
        Type rawtype;
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType && SimpleSolrRepository.class.equals((Object)(rawtype = (parameterizedType = (ParameterizedType)genericSuperclass).getRawType()))) {
            return parameterizedType;
        }
        return this.resolveReturnedClassFromGernericType(clazz.getSuperclass());
    }

    public Class<T> getEntityClass() {
        if (!this.isEntityClassSet()) {
            try {
                this.entityClass = this.resolveReturnedClassFromGernericType();
            }
            catch (Exception e) {
                throw new InvalidDataAccessApiUsageException("Unable to resolve EntityClass. Please use according setter!", (Throwable)e);
            }
        }
        return this.entityClass;
    }

    private boolean isEntityClassSet() {
        return this.entityClass != null;
    }

    public final void setEntityClass(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"EntityClass must not be null.");
        this.entityClass = entityClass;
    }

    public final void setSolrOperations(SolrOperations solrOperations) {
        Assert.notNull((Object)solrOperations, (String)"SolrOperations must not be null.");
        this.solrOperations = solrOperations;
    }

    public final SolrOperations getSolrOperations() {
        return this.solrOperations;
    }

    private Object extractIdFromBean(T entity) {
        if (this.entityInformation != null) {
            return this.entityInformation.getId(entity);
        }
        SolrInputDocument solrInputDocument = this.solrOperations.convertBeanToSolrInputDocument(entity);
        return this.extractIdFromSolrInputDocument(solrInputDocument);
    }

    private String extractIdFromSolrInputDocument(SolrInputDocument solrInputDocument) {
        Assert.notNull((Object)solrInputDocument.getField(this.idFieldName), (String)("Unable to find field '" + this.idFieldName + "' in SolrDocument."));
        Assert.notNull((Object)solrInputDocument.getField(this.idFieldName).getValue(), (String)"ID must not be 'null'.");
        return solrInputDocument.getField(this.idFieldName).getValue().toString();
    }

    private void registerTransactionSynchronisationIfSynchronisationActive() {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.registerTransactionSynchronisationAdapter();
        }
    }

    private void registerTransactionSynchronisationAdapter() {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)SolrTransactionSynchronizationAdapterBuilder.forOperations(this.solrOperations).withDefaultBehaviour());
    }

    private void commitIfTransactionSynchronisationIsInactive() {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            this.solrOperations.commit();
        }
    }
}

