/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.repository.query.SolrEntityInformation;

public class MappingSolrEntityInformation<T, ID extends Serializable>
extends AbstractEntityInformation<T, ID>
implements SolrEntityInformation<T, ID> {
    private final SolrPersistentEntity<T> entityMetadata;
    private final String solrCoreName;

    public MappingSolrEntityInformation(SolrPersistentEntity<T> entity) {
        this(entity, null);
    }

    public MappingSolrEntityInformation(SolrPersistentEntity<T> entity, String solrCoreName) {
        super(entity.getType());
        this.entityMetadata = entity;
        this.solrCoreName = solrCoreName;
    }

    public ID getId(T entity) {
        SolrPersistentProperty id = (SolrPersistentProperty)this.entityMetadata.getIdProperty();
        try {
            return (ID)((Serializable)BeanWrapper.create(entity, null).getProperty((PersistentProperty)id));
        }
        catch (Exception e) {
            throw new IllegalStateException("ID could not be resolved", e);
        }
    }

    public Class<ID> getIdType() {
        return ((SolrPersistentProperty)this.entityMetadata.getIdProperty()).getType();
    }

    @Override
    public String getIdAttribute() {
        return ((SolrPersistentProperty)this.entityMetadata.getIdProperty()).getFieldName();
    }

    @Override
    public String getSolrCoreName() {
        return this.solrCoreName != null ? this.solrCoreName : this.entityMetadata.getSolrCoreName();
    }
}

