/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.apache.solr.common.util.NamedList;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class SolrJsonResponse
extends SolrResponseBase {
    private static final long serialVersionUID = 5727953031460362404L;
    private JsonNode root;

    public void setResponse(NamedList<Object> response) {
        super.setResponse(response);
        try {
            this.root = new ObjectMapper().readTree((String)this.getResponse().get("json"));
        }
        catch (Exception e) {
            throw new InvalidDataAccessResourceUsageException("Unable to parse json from response.", (Throwable)e);
        }
    }

    public String getJsonResponse() {
        return (String)this.getResponse().get("json");
    }

    public JsonNode getNode(String name) {
        return this.root.findValue(name);
    }
}

