/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.SolrDataQuery;

public interface Query
extends SolrDataQuery {
    public static final int DEFAULT_PAGE_SIZE = 10;

    public <T extends Query> T addProjectionOnField(Field var1);

    public <T extends Query> T setPageRequest(Pageable var1);

    public <T extends Query> T setOffset(Integer var1);

    public <T extends Query> T setRows(Integer var1);

    public <T extends Query> T addGroupByField(Field var1);

    public <T extends Query> T addFilterQuery(FilterQuery var1);

    public <T extends Query> T setTimeAllowed(Integer var1);

    public List<FilterQuery> getFilterQueries();

    @Deprecated
    public Pageable getPageRequest();

    public Integer getOffset();

    public Integer getRows();

    public List<Field> getGroupByFields();

    public List<Field> getProjectionOnFields();

    public <T extends Query> T addSort(Sort var1);

    public Sort getSort();

    public Integer getTimeAllowed();

    public void setDefaultOperator(Operator var1);

    public Operator getDefaultOperator();

    public String getDefType();

    public void setDefType(String var1);

    public String getRequestHandler();

    public void setRequestHandler(String var1);

    public static enum Operator {
        AND("AND"),
        OR("OR"),
        NONE("");

        private String operator;

        private Operator(String operator) {
            this.operator = operator;
        }

        public String asQueryStringRepresentation() {
            return this.operator;
        }

        public String toString() {
            return this.asQueryStringRepresentation();
        }
    }
}

