/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.json.MappedJacksonProperties;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.Version;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.BeanDeserializerBuilder;
import tools.jackson.databind.deser.CreatorProperty;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.jdk.CollectionDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.deser.std.StdScalarDeserializer;
import tools.jackson.databind.deser.std.StdValueInstantiator;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.ValueSerializerModifier;
import tools.jackson.databind.ser.jackson.JsonValueSerializer;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.ser.std.ToStringSerializerBase;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.util.NameTransformer;

public class PersistentEntityJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = -7289265674870906323L;
    private static final Logger LOG = LoggerFactory.getLogger(PersistentEntityJacksonModule.class);
    private static final TypeDescriptor URI_DESCRIPTOR = TypeDescriptor.valueOf(URI.class);

    public PersistentEntityJacksonModule(Associations associations, PersistentEntities entities, UriToEntityConverter converter, LinkCollector collector, RepositoryInvokerFactory factory, LookupObjectSerializer lookupObjectSerializer, RepresentationModelProcessorInvoker invoker, EmbeddedResourcesAssembler assembler) {
        super("persistent-entity-resource", new Version(2, 0, 0, null, "org.springframework.data.rest", "jackson-module"));
        Assert.notNull((Object)associations, (String)"AssociationLinks must not be null");
        Assert.notNull((Object)entities, (String)"Repositories must not be null");
        Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null");
        Assert.notNull((Object)collector, (String)"LinkCollector must not be null");
        NestedEntitySerializer serializer = new NestedEntitySerializer(entities, assembler, invoker);
        this.addSerializer((ValueSerializer)new PersistentEntityResourceSerializer(collector));
        this.addSerializer((ValueSerializer)new ProjectionSerializer(collector, associations, invoker, false));
        this.addSerializer((ValueSerializer)new ProjectionResourceContentSerializer(false));
        this.setSerializerModifier(new AssociationOmittingSerializerModifier(entities, associations, serializer, lookupObjectSerializer));
        this.setDeserializerModifier(new AssociationUriResolvingDeserializerModifier(entities, associations, converter, factory));
    }

    static class NestedEntitySerializer
    extends StdSerializer<Object> {
        private final PersistentEntities entities;
        private final EmbeddedResourcesAssembler assembler;
        private final RepresentationModelProcessorInvoker invoker;

        public NestedEntitySerializer(PersistentEntities entities, EmbeddedResourcesAssembler assembler, RepresentationModelProcessorInvoker invoker) {
            super(Object.class);
            this.entities = entities;
            this.assembler = assembler;
            this.invoker = invoker;
        }

        public void serialize(Object value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
            if (value instanceof Collection) {
                Collection source = (Collection)value;
                ArrayList<Object> resources = new ArrayList<Object>();
                for (Object element : source) {
                    resources.add(this.toModel(element, provider));
                }
                provider.writeValue(gen, resources);
            } else if (value instanceof Map) {
                Map source = (Map)value;
                Map resources = CollectionFactory.createApproximateMap(value.getClass(), (int)source.size());
                for (Map.Entry entry : source.entrySet()) {
                    resources.put(entry.getKey(), this.toModel(entry.getValue(), provider));
                }
                provider.writeValue(gen, (Object)resources);
            } else {
                provider.writeValue(gen, this.toModel(value, provider));
            }
        }

        public void serializeWithType(Object value, JsonGenerator gen, SerializationContext provider, TypeSerializer typeSerializer) {
            this.serialize(value, gen, provider);
        }

        private Object toModel(Object value, SerializationContext provider) {
            ValueSerializer serializer = provider.findValueSerializer(value.getClass());
            if (JsonValueSerializer.class.isInstance(serializer)) {
                return value;
            }
            ValueSerializer unwrappingSerializer = serializer.unwrappingSerializer(NameTransformer.NOP);
            if (!unwrappingSerializer.isUnwrappingSerializer()) {
                return value;
            }
            PersistentEntity entity = this.entities.getRequiredPersistentEntity(value.getClass());
            return this.invoker.invokeProcessorsFor((RepresentationModel)PersistentEntityResource.build(value, entity).withEmbedded(this.assembler.getEmbeddedResources(value)).buildNested());
        }
    }

    private static class PersistentEntityResourceSerializer
    extends StdSerializer<PersistentEntityResource> {
        private final LinkCollector collector;

        private PersistentEntityResourceSerializer(LinkCollector collector) {
            super(PersistentEntityResource.class);
            this.collector = collector;
        }

        public void serialize(final PersistentEntityResource resource, JsonGenerator jgen, SerializationContext provider) {
            LOG.debug("Serializing PersistentEntity {}", resource.getPersistentEntity());
            Object content = resource.getContent();
            if (PersistentEntityResourceSerializer.hasScalarSerializer(content, provider)) {
                provider.writeValue(jgen, content);
                return;
            }
            Links links = this.getLinks(resource);
            if (TargetAware.class.isInstance(content)) {
                TargetAware targetAware = (TargetAware)content;
                provider.writeValue(jgen, (Object)new ProjectionResource(targetAware, (Iterable<Link>)links));
                return;
            }
            EntityModel<Object> resourceToRender = new EntityModel<Object>(this, resource.getContent(), (Iterable)links){
                final /* synthetic */ PersistentEntityResourceSerializer this$0;
                {
                    this.this$0 = this$0;
                    super(content, links);
                }

                @JsonUnwrapped
                public Iterable<?> getEmbedded() {
                    return resource.getEmbeddeds();
                }
            };
            provider.writeValue(jgen, (Object)resourceToRender);
        }

        private Links getLinks(PersistentEntityResource resource) {
            Object source = this.getLinkSource(resource.getContent());
            return resource.isNested() ? this.collector.getLinksForNested(source, resource.getLinks()) : this.collector.getLinksFor(source, resource.getLinks());
        }

        private Object getLinkSource(Object object) {
            return TargetAware.class.isInstance(object) ? ((TargetAware)object).getTarget() : object;
        }

        private static boolean hasScalarSerializer(Object source, SerializationContext provider) {
            ValueSerializer serializer = provider.findValueSerializer(source.getClass());
            return serializer instanceof ToStringSerializerBase || serializer instanceof StdScalarSerializer;
        }
    }

    static class ProjectionSerializer
    extends StdSerializer<TargetAware> {
        private final LinkCollector collector;
        private final Associations associations;
        private final RepresentationModelProcessorInvoker invoker;
        private final boolean unwrapping;

        ProjectionSerializer(LinkCollector collector, Associations mappings, RepresentationModelProcessorInvoker invoker, boolean unwrapping) {
            super(TargetAware.class);
            this.collector = collector;
            this.associations = mappings;
            this.invoker = invoker;
            this.unwrapping = unwrapping;
        }

        public void serialize(TargetAware value, JsonGenerator jgen, SerializationContext provider) throws JacksonException {
            if (!this.unwrapping) {
                jgen.writeStartObject();
            }
            provider.findValueSerializer(ProjectionResource.class).unwrappingSerializer(null).serialize((Object)this.toModel(value), jgen, provider);
            if (!this.unwrapping) {
                jgen.writeEndObject();
            }
        }

        public boolean isUnwrappingSerializer() {
            return this.unwrapping;
        }

        public ValueSerializer<TargetAware> unwrappingSerializer(NameTransformer unwrapper) {
            return new ProjectionSerializer(this.collector, this.associations, this.invoker, true);
        }

        ProjectionResource toModel(TargetAware value) {
            Object target = value.getTarget();
            ResourceMetadata metadata = this.associations.getMetadataFor(Objects.requireNonNull(value.getTargetClass()));
            Links links = metadata != null && metadata.isExported() ? this.collector.getLinksFor(target) : Links.NONE;
            EntityModel resource = (EntityModel)this.invoker.invokeProcessorsFor((RepresentationModel)EntityModel.of((Object)value, (Iterable)links));
            return new ProjectionResource((TargetAware)resource.getContent(), (Iterable<Link>)resource.getLinks());
        }
    }

    private static class ProjectionResourceContentSerializer
    extends StdSerializer<ProjectionResourceContent> {
        private final boolean unwrapping;

        public ProjectionResourceContentSerializer(boolean unwrapping) {
            super(ProjectionResourceContent.class);
            this.unwrapping = unwrapping;
        }

        public void serialize(ProjectionResourceContent value, JsonGenerator jgen, SerializationContext provider) {
            provider.findValueSerializer(value.getProjectionInterface()).unwrappingSerializer(null).serialize(value.getProjection(), jgen, provider);
        }

        public boolean isUnwrappingSerializer() {
            return this.unwrapping;
        }

        public ValueSerializer<ProjectionResourceContent> unwrappingSerializer(NameTransformer unwrapper) {
            return new ProjectionResourceContentSerializer(true);
        }
    }

    static class AssociationOmittingSerializerModifier
    extends ValueSerializerModifier {
        private final PersistentEntities entities;
        private final Associations associations;
        private final NestedEntitySerializer nestedEntitySerializer;
        private final LookupObjectSerializer lookupObjectSerializer;

        public AssociationOmittingSerializerModifier(PersistentEntities entities, Associations associations, NestedEntitySerializer nestedEntitySerializer, LookupObjectSerializer lookupObjectSerializer) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
            Assert.notNull((Object)associations, (String)"Associations must not be null");
            Assert.notNull((Object)((Object)nestedEntitySerializer), (String)"NestedEntitySerializer must not be null");
            Assert.notNull((Object)((Object)lookupObjectSerializer), (String)"LookupObjectSerializer must not be null");
            this.entities = entities;
            this.associations = associations;
            this.nestedEntitySerializer = nestedEntitySerializer;
            this.lookupObjectSerializer = lookupObjectSerializer;
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription.Supplier beanDesc, List<BeanPropertyWriter> beanProperties) {
            return this.entities.getPersistentEntity(beanDesc.getBeanClass()).map(entity -> {
                BeanDescription beanDescription = beanDesc.get();
                ArrayList<BeanPropertyWriter> result = new ArrayList<BeanPropertyWriter>();
                for (BeanPropertyWriter writer : beanProperties) {
                    Optional<PersistentProperty<?>> findProperty = this.findProperty(writer.getName(), (PersistentEntity<?, ? extends PersistentProperty<?>>)entity, beanDescription);
                    if (!findProperty.isPresent()) {
                        result.add(writer);
                        continue;
                    }
                    findProperty.flatMap(it -> {
                        if (this.associations.isLookupType((PersistentProperty<?>)it)) {
                            LOG.debug("Assigning lookup object serializer for {}", it);
                            writer.assignSerializer((ValueSerializer)this.lookupObjectSerializer);
                            return Optional.of(writer);
                        }
                        if (this.associations.isLinkableAssociation((PersistentProperty<?>)it)) {
                            return Optional.empty();
                        }
                        if (it.isIdProperty() && !this.associations.isIdExposed((PersistentEntity<?, ?>)entity)) {
                            return Optional.empty();
                        }
                        if (it.isVersionProperty()) {
                            return Optional.empty();
                        }
                        if (it.isEntity() && !writer.isUnwrapping()) {
                            LOG.debug("Assigning nested entity serializer for {}", it);
                            writer.assignSerializer((ValueSerializer)this.nestedEntitySerializer);
                        }
                        return Optional.of(writer);
                    }).ifPresent(result::add);
                }
                return result;
            }).orElse(beanProperties);
        }

        private Optional<? extends PersistentProperty<?>> findProperty(String finalName, PersistentEntity<?, ? extends PersistentProperty<?>> entity, BeanDescription description) {
            return description.findProperties().stream().filter(it -> it.getName().equals(finalName)).findFirst().map(it -> entity.getPersistentProperty(it.getInternalName()));
        }
    }

    public static class LookupObjectSerializer
    extends ToStringSerializerBase {
        private static final long serialVersionUID = -3033458643050330913L;
        private final PluginRegistry<EntityLookup<?>, Class<?>> lookups;

        public LookupObjectSerializer(PluginRegistry<EntityLookup<?>, Class<?>> lookups) {
            super(Object.class);
            Assert.notNull(lookups, (String)"EntityLookups must not be null");
            this.lookups = lookups;
        }

        public void serialize(Object value, JsonGenerator gen, SerializationContext provider) {
            if (value instanceof Collection) {
                gen.writeStartArray();
                for (Object element : (Collection)value) {
                    gen.writePOJO(this.getLookupKey(element));
                }
                gen.writeEndArray();
            } else {
                gen.writePOJO(this.getLookupKey(value));
            }
        }

        public String valueToString(Object value) {
            return value.toString();
        }

        private Object getLookupKey(Object value) {
            return this.lookups.getPluginFor(value.getClass()).map(it -> it).orElseThrow(() -> new IllegalArgumentException("No EntityLookup found for " + value.getClass().getName())).getResourceIdentifier(value);
        }
    }

    public static class AssociationUriResolvingDeserializerModifier
    extends ValueDeserializerModifier {
        private final PersistentEntities entities;
        private final Associations associationLinks;
        private final UriToEntityConverter converter;
        private final RepositoryInvokerFactory factory;

        public AssociationUriResolvingDeserializerModifier(PersistentEntities entities, Associations associations, UriToEntityConverter converter, RepositoryInvokerFactory factory) {
            Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
            Assert.notNull((Object)associations, (String)"Associations must not be null");
            Assert.notNull((Object)converter, (String)"UriToEntityConverter must not be null");
            Assert.notNull((Object)factory, (String)"RepositoryInvokerFactory must not be null");
            this.entities = entities;
            this.associationLinks = associations;
            this.converter = converter;
            this.factory = factory;
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription.Supplier beanDesc, BeanDeserializerBuilder builder) {
            ValueInstantiatorCustomizer customizer = new ValueInstantiatorCustomizer(builder.getValueInstantiator(), config);
            Iterator properties = builder.getProperties();
            this.entities.getPersistentEntity(beanDesc.getBeanClass()).ifPresent(entity -> {
                BeanDescription beanDescription = beanDesc.get();
                MappedJacksonProperties mapped = MappedJacksonProperties.forDescription(entity, beanDescription);
                while (properties.hasNext()) {
                    SettableBeanProperty property = (SettableBeanProperty)properties.next();
                    PersistentProperty<?> persistentProperty = mapped.getPersistentProperty(property.getName());
                    if (persistentProperty == null) continue;
                    TypeInformation propertyType = persistentProperty.getTypeInformation();
                    if (this.associationLinks.isLookupType(persistentProperty)) {
                        RepositoryInvokingDeserializer repositoryInvokingDeserializer = new RepositoryInvokingDeserializer(this.factory, persistentProperty);
                        ValueDeserializer<?> deserializer = AssociationUriResolvingDeserializerModifier.wrapIfCollection(propertyType, (ValueDeserializer<Object>)repositoryInvokingDeserializer, config);
                        builder.addOrReplaceProperty(property.withValueDeserializer(deserializer), false);
                        continue;
                    }
                    if (!this.associationLinks.isLinkableAssociation(persistentProperty)) continue;
                    Class actualPropertyType = persistentProperty.getActualType();
                    UriStringDeserializer uriStringDeserializer = new UriStringDeserializer(actualPropertyType, this.converter);
                    ValueDeserializer<?> deserializer = AssociationUriResolvingDeserializerModifier.wrapIfCollection(propertyType, (ValueDeserializer<Object>)uriStringDeserializer, config);
                    customizer.replacePropertyIfNeeded(builder, property.withValueDeserializer(deserializer));
                }
            });
            return customizer.conclude(builder);
        }

        private static ValueDeserializer<?> wrapIfCollection(TypeInformation<?> property, ValueDeserializer<Object> elementDeserializer, DeserializationConfig config) {
            if (!property.isCollectionLike()) {
                return elementDeserializer;
            }
            CollectionLikeType collectionType = config.getTypeFactory().constructCollectionLikeType(property.getType(), property.getRequiredActualType().getType());
            CollectionValueInstantiator instantiator = new CollectionValueInstantiator(property);
            return new CollectionDeserializer((JavaType)collectionType, elementDeserializer, null, (ValueInstantiator)instantiator);
        }

        public static class ValueInstantiatorCustomizer {
            public static final @Nullable Field CONSTRUCTOR_ARGS_FIELD = ReflectionUtils.findField(StdValueInstantiator.class, (String)"_constructorArguments");
            private final SettableBeanProperty[] properties;
            private final @Nullable StdValueInstantiator instantiator;

            ValueInstantiatorCustomizer(ValueInstantiator instantiator, DeserializationConfig config) {
                this.instantiator = StdValueInstantiator.class.isInstance(instantiator) ? (StdValueInstantiator)StdValueInstantiator.class.cast(instantiator) : null;
                this.properties = this.instantiator == null || this.instantiator.getFromObjectArguments(config) == null ? new SettableBeanProperty[]{} : (SettableBeanProperty[])this.instantiator.getFromObjectArguments(config).clone();
            }

            void replacePropertyIfNeeded(BeanDeserializerBuilder builder, SettableBeanProperty property) {
                builder.addOrReplaceProperty(property, false);
                if (!CreatorProperty.class.isInstance(property)) {
                    return;
                }
                this.properties[property.getCreatorIndex()] = property;
            }

            BeanDeserializerBuilder conclude(BeanDeserializerBuilder builder) {
                if (this.instantiator == null || CONSTRUCTOR_ARGS_FIELD == null) {
                    return builder;
                }
                ReflectionUtils.setField((Field)CONSTRUCTOR_ARGS_FIELD, (Object)this.instantiator, (Object)this.properties);
                builder.setValueInstantiator((ValueInstantiator)this.instantiator);
                return builder;
            }

            static {
                if (CONSTRUCTOR_ARGS_FIELD != null) {
                    ReflectionUtils.makeAccessible((Field)CONSTRUCTOR_ARGS_FIELD);
                }
            }
        }
    }

    private static class RepositoryInvokingDeserializer
    extends StdScalarDeserializer<Object> {
        private final RepositoryInvoker invoker;

        private RepositoryInvokingDeserializer(RepositoryInvokerFactory factory, PersistentProperty<?> property) {
            super(property.getActualType());
            this.invoker = factory.getInvokerFor(this._valueClass);
        }

        public @Nullable Object deserialize(JsonParser p, DeserializationContext ctxt) {
            Object id = p.currentToken().isNumeric() ? Long.valueOf(p.getValueAsLong()) : p.getValueAsString();
            return this.invoker.invokeFindById(id).orElse(null);
        }
    }

    static class CollectionValueInstantiator
    extends ValueInstantiator {
        private final TypeInformation<?> property;

        public CollectionValueInstantiator(TypeInformation<?> property) {
            Assert.notNull(property, (String)"Property must not be null");
            Assert.isTrue((property.isCollectionLike() || property.isMap() ? 1 : 0) != 0, (String)"Property must be a collection or map property");
            this.property = property;
        }

        public String getValueTypeDesc() {
            return this.property.getType().getName();
        }

        public ValueInstantiator createContextual(DeserializationContext ctxt, BeanDescription.Supplier beanDescRef) {
            return this;
        }

        public Class<?> getValueClass() {
            return this.property.getType();
        }

        public Object createUsingDefault(DeserializationContext ctxt) throws JacksonException {
            Class collectionOrMapType = this.property.getType();
            return this.property.isMap() ? CollectionFactory.createMap((Class)collectionOrMapType, (int)0) : CollectionFactory.createCollection((Class)collectionOrMapType, (int)0);
        }
    }

    static class ProjectionResourceContent {
        private final Object projection;
        private final Class<?> projectionInterface;

        public ProjectionResourceContent(Object projection, Class<?> projectionInterface) {
            this.projection = projection;
            this.projectionInterface = projectionInterface;
        }

        public Object getProjection() {
            return this.projection;
        }

        public Class<?> getProjectionInterface() {
            return this.projectionInterface;
        }
    }

    static class ProjectionResource
    extends EntityModel<ProjectionResourceContent> {
        ProjectionResource(TargetAware projection, Iterable<Link> links) {
            super((Object)new ProjectionResourceContent(projection, projection.getClass().getInterfaces()[0]), links);
        }
    }

    public static class UriStringDeserializer
    extends StdDeserializer<Object> {
        private static final String UNEXPECTED_VALUE = "Expected URI cause property %s points to the managed domain type";
        private final Class<?> type;
        private final UriToEntityConverter converter;

        public UriStringDeserializer(Class<?> type, UriToEntityConverter converter) {
            super(type);
            this.type = type;
            this.converter = converter;
        }

        public @Nullable Object deserialize(JsonParser jp, DeserializationContext ctxt) {
            String source = jp.getValueAsString();
            if (!StringUtils.hasText((String)source)) {
                return null;
            }
            try {
                URI uri = UriTemplate.of((String)source).expand(new Object[0]);
                TypeDescriptor typeDescriptor = TypeDescriptor.valueOf(this.type);
                return this.converter.convert((Object)uri, URI_DESCRIPTOR, typeDescriptor);
            }
            catch (IllegalArgumentException o_O) {
                throw ctxt.weirdStringException(source, URI.class, String.format(UNEXPECTED_VALUE, this.type));
            }
        }

        public @Nullable Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) {
            return this.deserialize(jp, ctxt);
        }
    }
}

