/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import jakarta.servlet.http.HttpServletRequest;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public enum HttpMethodHandlerMethodArgumentResolver implements HandlerMethodArgumentResolver
{
    INSTANCE;


    public boolean supportsParameter(MethodParameter parameter) {
        return HttpMethod.class.equals((Object)parameter.getParameterType());
    }

    public HttpMethod resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (httpServletRequest == null) {
            throw new IllegalStateException("No HttpServletRequest available to resolve HttpMethod argument");
        }
        return HttpMethod.valueOf((String)httpServletRequest.getMethod().trim().toUpperCase());
    }
}

