/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwareDefaultedPageableArgumentResolver
implements HandlerMethodArgumentResolver {
    private final JacksonMappingAwareSortTranslator translator;
    private final PageableHandlerMethodArgumentResolver delegate;

    public MappingAwareDefaultedPageableArgumentResolver(JacksonMappingAwareSortTranslator translator, PageableHandlerMethodArgumentResolver delegate) {
        Assert.notNull((Object)translator, (String)"JacksonMappingAwareSortTranslator must not be null");
        Assert.notNull((Object)delegate, (String)"Delegate PageableHandlerMethodArgumentResolver must not be null");
        this.translator = translator;
        this.delegate = delegate;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return DefaultedPageable.class.isAssignableFrom(parameter.getParameterType());
    }

    public @Nullable Object resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        Pageable pageable = this.delegate.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (pageable == null || pageable.getSort() == null) {
            return new DefaultedPageable(pageable, this.delegate.isFallbackPageable(pageable));
        }
        Sort translated = this.translator.translateSort(pageable.getSort(), parameter, webRequest);
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)translated);
        return new DefaultedPageable(pageable, this.delegate.isFallbackPageable(pageable));
    }
}

