/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.util.Assert;

public class DefaultLinkCollector
implements LinkCollector {
    private final PersistentEntities entities;
    private final Associations associationLinks;
    private final SelfLinkProvider links;

    public DefaultLinkCollector(PersistentEntities entities, SelfLinkProvider linkProvider, Associations associationLinks) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
        Assert.notNull((Object)linkProvider, (String)"SelfLinkProvider must not be null");
        Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null");
        this.links = linkProvider;
        this.entities = entities;
        this.associationLinks = associationLinks;
    }

    @Override
    public Links getLinksFor(Object object) {
        return this.getLinksFor(object, Links.NONE);
    }

    @Override
    public Links getLinksFor(Object object, Links existingLinks) {
        Assert.notNull((Object)object, (String)"Object must not be null");
        Assert.notNull((Object)existingLinks, (String)"Existing links must not be null");
        Link selfLink = this.createSelfLink(object, existingLinks);
        if (selfLink == null) {
            return existingLinks;
        }
        Path path = new Path(selfLink.expand(new Object[0]).getHref());
        LinkCollectingAssociationHandler handler = new LinkCollectingAssociationHandler(path, this.associationLinks);
        this.entities.getRequiredPersistentEntity(object.getClass()).doWithAssociations((SimpleAssociationHandler)handler);
        return this.addSelfLinkIfNecessary(object, existingLinks.and((Iterable)handler.getLinks()));
    }

    @Override
    public Links getLinksForNested(Object object, Links existing) {
        PersistentEntity entity = this.entities.getRequiredPersistentEntity(object.getClass());
        NestedLinkCollectingAssociationHandler handler = new NestedLinkCollectingAssociationHandler(this.links, entity.getPropertyAccessor(object), this.associationLinks);
        entity.doWithAssociations((SimpleAssociationHandler)handler);
        return existing.and(handler.getLinks());
    }

    private Links addSelfLinkIfNecessary(Object object, Links existing) {
        return existing.andIf(!existing.hasLink(IanaLinkRelations.SELF), new Supplier[]{() -> this.links.createSelfLinkFor(object).withSelfRel()});
    }

    private Link createSelfLink(Object object, Links existing) {
        return existing.getLink(IanaLinkRelations.SELF).orElseGet(() -> this.links.createSelfLinkFor(object).withSelfRel());
    }

    private static class LinkCollectingAssociationHandler
    implements SimpleAssociationHandler {
        private static final String AMBIGUOUS_ASSOCIATIONS = "Detected multiple association links with same relation type; Disambiguate association %s using @RestResource";
        private final Path basePath;
        private final Associations associationLinks;
        private final List<Link> links = new ArrayList<Link>();

        public LinkCollectingAssociationHandler(Path basePath, Associations associationLinks) {
            Assert.notNull((Object)basePath, (String)"Base Path must not be null");
            Assert.notNull((Object)associationLinks, (String)"Associations must not be null");
            this.basePath = basePath;
            this.associationLinks = associationLinks;
        }

        public Links getLinks() {
            return Links.of(this.links);
        }

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            if (this.associationLinks.isLinkableAssociation(association)) {
                PersistentProperty property = association.getInverse();
                Links existingLinks = Links.of(this.links);
                for (Link link : this.associationLinks.getLinksFor(association, this.basePath)) {
                    if (existingLinks.hasLink(link.getRel())) {
                        throw new MappingException(String.format(AMBIGUOUS_ASSOCIATIONS, property.toString()));
                    }
                    this.links.add(link);
                }
            }
        }
    }

    private static class NestedLinkCollectingAssociationHandler
    implements SimpleAssociationHandler {
        private final SelfLinkProvider selfLinks;
        private final PersistentPropertyAccessor<?> accessor;
        private final Associations associations;
        private Links links = Links.NONE;

        public NestedLinkCollectingAssociationHandler(SelfLinkProvider selfLinks, PersistentPropertyAccessor<?> accessor, Associations associations) {
            Assert.notNull((Object)selfLinks, (String)"SelfLinkProvider must not be null");
            Assert.notNull(accessor, (String)"PersistentPropertyAccessor must not be null");
            Assert.notNull((Object)associations, (String)"Associations must not be null");
            this.selfLinks = selfLinks;
            this.accessor = accessor;
            this.associations = associations;
        }

        public List<Link> getLinks() {
            return this.links.toList();
        }

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            if (!this.associations.isLinkableAssociation(association)) {
                return;
            }
            PersistentProperty property = association.getInverse();
            Object value = this.accessor.getProperty(property);
            if (value == null) {
                return;
            }
            ResourceMetadata metadata = this.associations.getMappings().getMetadataFor(property.getOwner().getType());
            ResourceMapping propertyMapping = metadata.getMappingFor(property);
            for (Object element : NestedLinkCollectingAssociationHandler.asCollection(value)) {
                this.links = this.links.andIf(element != null, new Supplier[]{() -> this.selfLinks.createSelfLinkFor(property.getAssociationTargetType(), element).withRel(propertyMapping.getRel())});
            }
        }

        private static Collection<Object> asCollection(Object object) {
            return object instanceof Collection ? (Set<Object>)object : Collections.singleton(object);
        }
    }
}

