/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.util.ProxyUtils;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class BasePathAwareHandlerMapping
extends RequestMappingHandlerMapping {
    private static final String AT_REQUEST_MAPPING_ON_TYPE = "Spring Data REST controller %s must not use @RequestMapping on class level as this would cause double registration with Spring MVC";
    private final RepositoryRestConfiguration configuration;
    private final String baseUri;

    public BasePathAwareHandlerMapping(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null");
        this.configuration = configuration;
        this.baseUri = configuration.getBasePath().toString();
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        boolean defaultFound = false;
        for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
            MediaType rawtype = mediaType.removeQualityValue();
            if (rawtype.equals((Object)this.configuration.getDefaultMediaType())) {
                defaultFound = true;
            }
            if (rawtype.equals((Object)MediaType.ALL)) continue;
            mediaTypes.add(mediaType);
        }
        if (!defaultFound) {
            mediaTypes.add(this.configuration.getDefaultMediaType());
        }
        return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)new CustomAcceptHeaderHttpServletRequest(request, mediaTypes));
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        return true;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        ProducesRequestCondition producesCondition = this.customize(info.getProducesCondition());
        Set mediaTypes = producesCondition.getProducibleMediaTypes();
        String[] customPrefixes = this.getBasePathedPrefixes(handlerType);
        RequestMappingInfo.Builder builder = info.mutate();
        if (customPrefixes.length != 0 || StringUtils.hasText((String)this.baseUri)) {
            builder = builder.paths(this.resolveEmbeddedValuesInPatterns(customPrefixes));
        }
        return builder.produces((String[])mediaTypes.stream().map(MimeType::toString).toArray(String[]::new)).build().combine(info);
    }

    protected ProducesRequestCondition customize(ProducesRequestCondition condition) {
        return condition;
    }

    @Deprecated
    protected boolean isHandler(Class<?> beanType) {
        Class type = ProxyUtils.getUserClass(beanType);
        boolean isSpringDataRestHandler = this.isHandlerInternal(type);
        if (!isSpringDataRestHandler) {
            return false;
        }
        if (AnnotatedElementUtils.hasAnnotation((AnnotatedElement)type, RequestMapping.class)) {
            throw new IllegalStateException(String.format(AT_REQUEST_MAPPING_ON_TYPE, beanType.getName()));
        }
        return isSpringDataRestHandler;
    }

    protected boolean isHandlerInternal(Class<?> type) {
        return type.isAnnotationPresent(BasePathAwareController.class);
    }

    private String[] getBasePathedPrefixes(Class<?> handlerType) {
        String[] stringArray;
        String[] customPrefixes;
        Assert.notNull(handlerType, (String)"Handler type must not be null");
        BasePathAwareController mergedAnnotation = (BasePathAwareController)AnnotatedElementUtils.findMergedAnnotation(handlerType, BasePathAwareController.class);
        String[] stringArray2 = customPrefixes = mergedAnnotation == null ? new String[]{} : mergedAnnotation.value();
        if (customPrefixes.length == 0) {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.baseUri;
        } else {
            stringArray = (String[])Arrays.stream(customPrefixes).map(this.baseUri::concat).toArray(String[]::new);
        }
        return stringArray;
    }

    static class CustomAcceptHeaderHttpServletRequest
    extends HttpServletRequestWrapper {
        private final List<MediaType> acceptMediaTypes;
        private final List<String> acceptMediaTypeStrings;

        public CustomAcceptHeaderHttpServletRequest(HttpServletRequest request, List<MediaType> acceptMediaTypes) {
            super(request);
            Assert.notEmpty(acceptMediaTypes, (String)"MediaTypes must not be empty");
            this.acceptMediaTypes = acceptMediaTypes;
            ArrayList<String> acceptMediaTypeStrings = new ArrayList<String>(acceptMediaTypes.size());
            for (MediaType mediaType : acceptMediaTypes) {
                acceptMediaTypeStrings.add(mediaType.toString());
            }
            this.acceptMediaTypeStrings = acceptMediaTypeStrings;
        }

        public String getHeader(String name) {
            return "Accept".equalsIgnoreCase(name) && this.acceptMediaTypes != null ? StringUtils.collectionToCommaDelimitedString(this.acceptMediaTypes) : super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            return "Accept".equalsIgnoreCase(name) && this.acceptMediaTypes != null ? Collections.enumeration(this.acceptMediaTypeStrings) : super.getHeaders(name);
        }
    }
}

