/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.Objects;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;

public final class DefaultedPageable {
    private final Pageable pageable;
    private final boolean isDefault;

    public DefaultedPageable(Pageable pageable, boolean isDefault) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null");
        this.pageable = pageable;
        this.isDefault = isDefault;
    }

    public Pageable getPageable() {
        return this.pageable;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Pageable unpagedIfDefault() {
        return this.isDefault ? Pageable.unpaged() : this.pageable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultedPageable)) {
            return false;
        }
        DefaultedPageable that = (DefaultedPageable)o;
        return Objects.equals(this.pageable, that.pageable) && this.isDefault == that.isDefault;
    }

    public int hashCode() {
        return Objects.hash(this.pageable, this.isDefault);
    }

    public String toString() {
        return "DefaultedPageable(pageable=" + this.pageable + ", isDefault=" + this.isDefault + ")";
    }
}

