/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json.patch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.rest.webmvc.json.patch.AddOperation;
import org.springframework.data.rest.webmvc.json.patch.CopyOperation;
import org.springframework.data.rest.webmvc.json.patch.JsonLateObjectEvaluator;
import org.springframework.data.rest.webmvc.json.patch.MoveOperation;
import org.springframework.data.rest.webmvc.json.patch.Patch;
import org.springframework.data.rest.webmvc.json.patch.PatchConverter;
import org.springframework.data.rest.webmvc.json.patch.PatchException;
import org.springframework.data.rest.webmvc.json.patch.PatchOperation;
import org.springframework.data.rest.webmvc.json.patch.RemoveOperation;
import org.springframework.data.rest.webmvc.json.patch.ReplaceOperation;
import org.springframework.data.rest.webmvc.json.patch.TestOperation;
import org.springframework.util.Assert;

public class JsonPatchPatchConverter
implements PatchConverter<JsonNode> {
    private final ObjectMapper mapper;

    public JsonPatchPatchConverter(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        this.mapper = mapper;
    }

    @Override
    public Patch convert(JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            throw new IllegalArgumentException("JsonNode must be an instance of ArrayNode");
        }
        ArrayNode opNodes = (ArrayNode)jsonNode;
        ArrayList<PatchOperation> ops = new ArrayList<PatchOperation>(opNodes.size());
        Iterator elements = opNodes.elements();
        while (elements.hasNext()) {
            String from;
            JsonNode opNode = (JsonNode)elements.next();
            String opType = opNode.get("op").textValue();
            String path = opNode.get("path").textValue();
            JsonNode valueNode = opNode.get("value");
            Object value = this.valueFromJsonNode(path, valueNode);
            String string = from = opNode.has("from") ? opNode.get("from").textValue() : null;
            if (opType.equals("test")) {
                ops.add(TestOperation.whetherValueAt(path).hasValue(value));
                continue;
            }
            if (opType.equals("replace")) {
                ops.add(ReplaceOperation.valueAt(path).with(value));
                continue;
            }
            if (opType.equals("remove")) {
                ops.add(RemoveOperation.valueAt(path));
                continue;
            }
            if (opType.equals("add")) {
                ops.add(AddOperation.of(path, value));
                continue;
            }
            if (opType.equals("copy")) {
                ops.add(CopyOperation.from(from).to(path));
                continue;
            }
            if (opType.equals("move")) {
                ops.add(MoveOperation.from(from).to(path));
                continue;
            }
            throw new PatchException("Unrecognized operation type: " + opType);
        }
        return new Patch(ops);
    }

    private Object valueFromJsonNode(String path, JsonNode valueNode) {
        if (valueNode == null || valueNode.isNull()) {
            return null;
        }
        if (valueNode.isTextual()) {
            return valueNode.asText();
        }
        if (valueNode.isFloatingPointNumber()) {
            return valueNode.asDouble();
        }
        if (valueNode.isBoolean()) {
            return valueNode.asBoolean();
        }
        if (valueNode.isInt()) {
            return valueNode.asInt();
        }
        if (valueNode.isLong()) {
            return valueNode.asLong();
        }
        if (valueNode.isObject() || valueNode.isArray()) {
            return new JsonLateObjectEvaluator(this.mapper, valueNode);
        }
        throw new PatchException(String.format("Unrecognized valueNode type at path %s and value node %s", path, valueNode));
    }
}

