/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.util.ProxyUtils;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class BasePathAwareHandlerMapping
extends RequestMappingHandlerMapping {
    private final RepositoryRestConfiguration configuration;

    public BasePathAwareHandlerMapping(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.configuration = configuration;
        String baseUri = configuration.getBasePath().toString();
        if (StringUtils.hasText((String)baseUri)) {
            HashMap<String, Predicate<Class>> prefixes = new HashMap<String, Predicate<Class>>();
            prefixes.put(baseUri, it -> true);
            this.setPathPrefixes(prefixes);
        }
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        boolean defaultFound = false;
        for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
            MediaType rawtype = mediaType.removeQualityValue();
            if (rawtype.equals((Object)this.configuration.getDefaultMediaType())) {
                defaultFound = true;
            }
            if (rawtype.equals((Object)MediaType.ALL)) continue;
            mediaTypes.add(mediaType);
        }
        if (!defaultFound) {
            mediaTypes.add(this.configuration.getDefaultMediaType());
        }
        return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)new CustomAcceptHeaderHttpServletRequest(request, mediaTypes));
    }

    protected boolean hasCorsConfigurationSource(Object handler) {
        return true;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        ProducesRequestCondition producesCondition = this.customize(info.getProducesCondition());
        return new RequestMappingInfo(info.getPatternsCondition(), info.getMethodsCondition(), info.getParamsCondition(), info.getHeadersCondition(), info.getConsumesCondition(), producesCondition, info.getCustomCondition());
    }

    protected ProducesRequestCondition customize(ProducesRequestCondition condition) {
        return condition;
    }

    protected boolean isHandler(Class<?> beanType) {
        Class type = ProxyUtils.getUserClass(beanType);
        return type.isAnnotationPresent(BasePathAwareController.class);
    }

    static class CustomAcceptHeaderHttpServletRequest
    extends HttpServletRequestWrapper {
        private final List<MediaType> acceptMediaTypes;
        private final List<String> acceptMediaTypeStrings;

        public CustomAcceptHeaderHttpServletRequest(HttpServletRequest request, List<MediaType> acceptMediaTypes) {
            super(request);
            Assert.notEmpty(acceptMediaTypes, (String)"MediaTypes must not be empty!");
            this.acceptMediaTypes = acceptMediaTypes;
            ArrayList<String> acceptMediaTypeStrings = new ArrayList<String>(acceptMediaTypes.size());
            for (MediaType mediaType : acceptMediaTypes) {
                acceptMediaTypeStrings.add(mediaType.toString());
            }
            this.acceptMediaTypeStrings = acceptMediaTypeStrings;
        }

        public String getHeader(String name) {
            return "Accept".equalsIgnoreCase(name) && this.acceptMediaTypes != null ? StringUtils.collectionToCommaDelimitedString(this.acceptMediaTypes) : super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            return "Accept".equalsIgnoreCase(name) && this.acceptMediaTypes != null ? Collections.enumeration(this.acceptMediaTypeStrings) : super.getHeaders(name);
        }
    }
}

