/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.util.ProxyUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.util.pattern.PathPatternParser;

public class RepositoryRestHandlerMapping
extends BasePathAwareHandlerMapping {
    private static final PathPatternParser PARSER = new PathPatternParser();
    static final String EFFECTIVE_LOOKUP_PATH_ATTRIBUTE = RepositoryRestHandlerMapping.class.getName() + ".EFFECTIVE_REPOSITORY_RESOURCE_LOOKUP_PATH";
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration configuration;
    private final Optional<Repositories> repositories;
    private RepositoryCorsConfigurationAccessor corsConfigurationAccessor;
    private Optional<JpaHelper> jpaHelper = Optional.empty();

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config) {
        this(mappings, config, Optional.empty());
    }

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config, Repositories repositories) {
        this(mappings, config, Optional.of(repositories));
    }

    private RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config, Optional<Repositories> repositories) {
        super(config);
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull(repositories, (String)"Repositories must not be null!");
        this.mappings = mappings;
        this.configuration = config;
        this.repositories = repositories;
        this.corsConfigurationAccessor = new RepositoryCorsConfigurationAccessor(mappings, NoOpStringValueResolver.INSTANCE, repositories);
    }

    public void setJpaHelper(JpaHelper jpaHelper) {
        this.jpaHelper = Optional.ofNullable(jpaHelper);
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        super.setEmbeddedValueResolver(resolver);
        this.corsConfigurationAccessor = new RepositoryCorsConfigurationAccessor(this.mappings, resolver == null ? NoOpStringValueResolver.INSTANCE : resolver, this.repositories);
    }

    @Override
    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        HandlerMethod handlerMethod = super.lookupHandlerMethod(lookupPath, request);
        if (handlerMethod == null) {
            return null;
        }
        String repositoryLookupPath = new BaseUri(this.configuration.getBasePath()).getRepositoryLookupPath(lookupPath);
        if (!StringUtils.hasText((String)repositoryLookupPath)) {
            return handlerMethod;
        }
        String repositoryBasePath = RepositoryRestHandlerMapping.getRepositoryBasePath(repositoryLookupPath);
        if (!this.mappings.exportsTopLevelResourceFor(repositoryBasePath)) {
            return null;
        }
        this.exposeEffectiveLookupPathKey(handlerMethod, request, repositoryBasePath);
        return handlerMethod;
    }

    protected HandlerMethod handleNoMatch(Set<RequestMappingInfo> requestMappingInfos, String lookupPath, HttpServletRequest request) throws ServletException {
        return null;
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        Class type = ProxyUtils.getUserClass(beanType);
        return AnnotationUtils.findAnnotation((Class)type, RepositoryRestController.class) != null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        this.jpaHelper.map(JpaHelper::getInterceptors).orElseGet(() -> Collections.emptyList()).forEach(interceptors::add);
    }

    @Override
    protected ProducesRequestCondition customize(ProducesRequestCondition condition) {
        if (!condition.isEmpty()) {
            return condition;
        }
        LinkedHashSet<String> mediaTypes = new LinkedHashSet<String>();
        mediaTypes.add(this.configuration.getDefaultMediaType().toString());
        mediaTypes.add("application/json");
        return new ProducesRequestCondition(mediaTypes.toArray(new String[mediaTypes.size()]));
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, HttpServletRequest request) {
        String lookupPath = this.getUrlPathHelper().getLookupPathForRequest(request);
        String repositoryLookupPath = new BaseUri(this.configuration.getBasePath()).getRepositoryLookupPath(lookupPath);
        CorsConfiguration corsConfiguration = super.getCorsConfiguration(handler, request);
        return this.repositories.filter(it -> StringUtils.hasText((String)repositoryLookupPath)).flatMap(it -> this.corsConfigurationAccessor.findCorsConfiguration(repositoryLookupPath)).map(it -> it.combine(corsConfiguration)).orElse(corsConfiguration);
    }

    private static String getRepositoryBasePath(String repositoryLookupPath) {
        int secondSlashIndex = repositoryLookupPath.indexOf(47, repositoryLookupPath.startsWith("/") ? 1 : 0);
        return secondSlashIndex == -1 ? repositoryLookupPath : repositoryLookupPath.substring(0, secondSlashIndex);
    }

    private void exposeEffectiveLookupPathKey(HandlerMethod method, HttpServletRequest request, String repositoryBasePath) {
        RequestMappingInfo mappingInfo = this.getMappingForMethod(method.getMethod(), method.getBeanType());
        if (mappingInfo == null) {
            return;
        }
        String pattern = (String)mappingInfo.getPatternsCondition().getMatchingCondition(request).getPatterns().iterator().next();
        request.setAttribute(EFFECTIVE_LOOKUP_PATH_ATTRIBUTE, (Object)PARSER.parse(pattern.replace("/{repository}", repositoryBasePath)));
    }

    static class RepositoryCorsConfigurationAccessor {
        private final ResourceMappings mappings;
        private final StringValueResolver embeddedValueResolver;
        private final Optional<Repositories> repositories;

        public RepositoryCorsConfigurationAccessor(ResourceMappings mappings, StringValueResolver embeddedValueResolver, Optional<Repositories> repositories) {
            Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
            Assert.notNull((Object)embeddedValueResolver, (String)"StringValueResolver must not be null!");
            Assert.notNull(repositories, (String)"Repositories must not be null!");
            this.mappings = mappings;
            this.embeddedValueResolver = embeddedValueResolver;
            this.repositories = repositories;
        }

        Optional<CorsConfiguration> findCorsConfiguration(String lookupPath) {
            return this.getResourceMetadata(RepositoryRestHandlerMapping.getRepositoryBasePath(lookupPath)).flatMap(it -> this.repositories.flatMap(foo -> foo.getRepositoryInformationFor(it.getDomainType()))).map(it -> it.getRepositoryInterface()).map(it -> this.createConfiguration((Class<?>)it));
        }

        private Optional<ResourceMetadata> getResourceMetadata(String basePath) {
            if (!this.mappings.exportsTopLevelResourceFor(basePath)) {
                return Optional.empty();
            }
            return this.mappings.stream().filter(it -> it.getPath().matches(basePath) && it.isExported()).findFirst();
        }

        protected CorsConfiguration createConfiguration(Class<?> repositoryInterface) {
            CrossOrigin typeAnnotation = (CrossOrigin)AnnotatedElementUtils.findMergedAnnotation(repositoryInterface, CrossOrigin.class);
            if (typeAnnotation == null) {
                return null;
            }
            CorsConfiguration config = new CorsConfiguration();
            this.updateCorsConfig(config, typeAnnotation);
            config.applyPermitDefaultValues();
            return config;
        }

        private void updateCorsConfig(CorsConfiguration config, CrossOrigin annotation) {
            for (String string : annotation.origins()) {
                config.addAllowedOrigin(this.resolveCorsAnnotationValue(string));
            }
            for (String string : annotation.methods()) {
                config.addAllowedMethod(string.name());
            }
            for (String string : annotation.allowedHeaders()) {
                config.addAllowedHeader(this.resolveCorsAnnotationValue(string));
            }
            for (String string : annotation.exposedHeaders()) {
                config.addExposedHeader(this.resolveCorsAnnotationValue(string));
            }
            String allowCredentials = this.resolveCorsAnnotationValue(annotation.allowCredentials());
            if ("true".equalsIgnoreCase(allowCredentials)) {
                config.setAllowCredentials(Boolean.valueOf(true));
            } else if ("false".equalsIgnoreCase(allowCredentials)) {
                config.setAllowCredentials(Boolean.valueOf(false));
            } else if (!allowCredentials.isEmpty()) {
                throw new IllegalStateException("@CrossOrigin's allowCredentials value must be \"true\", \"false\", or an empty string (\"\"): current value is [" + allowCredentials + "]");
            }
            if (annotation.maxAge() >= 0L && config.getMaxAge() == null) {
                config.setMaxAge(Long.valueOf(annotation.maxAge()));
            }
        }

        private String resolveCorsAnnotationValue(String value) {
            return this.embeddedValueResolver.resolveStringValue(value);
        }
    }

    static enum NoOpStringValueResolver implements StringValueResolver
    {
        INSTANCE;


        public String resolveStringValue(String value) {
            return value;
        }
    }
}

