/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

class MappedProperties {
    private final Map<PersistentProperty<?>, BeanPropertyDefinition> propertyToFieldName;
    private final Map<String, PersistentProperty<?>> fieldNameToProperty;
    private final Set<BeanPropertyDefinition> unmappedProperties;
    private final Set<String> ignoredPropertyNames;
    private final boolean anySetterFound;

    private MappedProperties(PersistentEntity<?, ? extends PersistentProperty<?>> entity, BeanDescription description) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        Assert.notNull((Object)description, (String)"BeanDescription must not be null!");
        this.propertyToFieldName = new HashMap();
        this.fieldNameToProperty = new HashMap();
        this.unmappedProperties = new HashSet<BeanPropertyDefinition>();
        this.anySetterFound = description.findAnySetterAccessor() != null;
        this.ignoredPropertyNames = description.getIgnoredPropertyNames();
        for (BeanPropertyDefinition property : description.findProperties()) {
            if (this.ignoredPropertyNames.contains(property.getName())) continue;
            Optional<PersistentProperty> persistentProperty = Optional.ofNullable(entity.getPersistentProperty(property.getInternalName()));
            persistentProperty.ifPresent(it -> {
                this.propertyToFieldName.put((PersistentProperty<?>)it, property);
                this.fieldNameToProperty.put(property.getName(), (PersistentProperty<?>)it);
            });
            if (persistentProperty.isPresent()) continue;
            this.unmappedProperties.add(property);
        }
    }

    public static MappedProperties forDeserialization(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        DeserializationConfig config = mapper.getDeserializationConfig();
        ClassIntrospector introspector = config.getClassIntrospector();
        BeanDescription description = introspector.forDeserialization(config, mapper.constructType((Type)entity.getType()), (ClassIntrospector.MixInResolver)config);
        return new MappedProperties(entity, description);
    }

    public static MappedProperties forSerialization(PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        SerializationConfig config = mapper.getSerializationConfig();
        ClassIntrospector introspector = config.getClassIntrospector();
        BeanDescription description = introspector.forSerialization(config, mapper.constructType((Type)entity.getType()), (ClassIntrospector.MixInResolver)config);
        return new MappedProperties(entity, description);
    }

    public static MappedProperties none() {
        return new MappedProperties(Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptySet(), false);
    }

    public String getMappedName(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        return this.propertyToFieldName.get(property).getName();
    }

    public boolean hasPersistentPropertyForField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperty.containsKey(fieldName);
    }

    public PersistentProperty<?> getPersistentProperty(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperty.get(fieldName);
    }

    public Iterable<String> getSpringDataUnmappedProperties() {
        if (this.unmappedProperties.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<String> result = new ArrayList<String>(this.unmappedProperties.size());
        for (BeanPropertyDefinition definitions : this.unmappedProperties) {
            result.add(definitions.getInternalName());
        }
        return result;
    }

    public boolean isMappedProperty(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        return this.propertyToFieldName.containsKey(property);
    }

    public boolean isWritableProperty(String name) {
        Assert.hasText((String)name, (String)"Property name must not be null or empty!");
        if (this.ignoredPropertyNames.contains(name)) {
            return false;
        }
        PersistentProperty<?> property = this.fieldNameToProperty.get(name);
        return property != null ? property.isWritable() : this.anySetterFound;
    }

    private MappedProperties(Map<PersistentProperty<?>, BeanPropertyDefinition> propertyToFieldName, Map<String, PersistentProperty<?>> fieldNameToProperty, Set<BeanPropertyDefinition> unmappedProperties, Set<String> ignoredPropertyNames, boolean anySetterFound) {
        this.propertyToFieldName = propertyToFieldName;
        this.fieldNameToProperty = fieldNameToProperty;
        this.unmappedProperties = unmappedProperties;
        this.ignoredPropertyNames = ignoredPropertyNames;
        this.anySetterFound = anySetterFound;
    }
}

