/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.ProducesRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UrlPathHelper;

public class BasePathAwareHandlerMapping
extends RequestMappingHandlerMapping {
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();
    private final RepositoryRestConfiguration configuration;
    private String prefix;

    public BasePathAwareHandlerMapping(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.configuration = configuration;
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        boolean defaultFound = false;
        for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
            MediaType rawtype = mediaType.removeQualityValue();
            if (rawtype.equals((Object)this.configuration.getDefaultMediaType())) {
                defaultFound = true;
            }
            if (rawtype.equals((Object)MediaType.ALL)) continue;
            mediaTypes.add(mediaType);
        }
        if (!defaultFound) {
            mediaTypes.add(this.configuration.getDefaultMediaType());
        }
        return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)new CustomAcceptHeaderHttpServletRequest(request, mediaTypes));
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo info = super.getMappingForMethod(method, handlerType);
        if (info == null) {
            return null;
        }
        PatternsRequestCondition patternsCondition = this.customize(info.getPatternsCondition(), this.prefix);
        ProducesRequestCondition producesCondition = this.customize(info.getProducesCondition());
        return new RequestMappingInfo(patternsCondition, info.getMethodsCondition(), info.getParamsCondition(), info.getHeadersCondition(), info.getConsumesCondition(), producesCondition, info.getCustomCondition());
    }

    protected PatternsRequestCondition customize(PatternsRequestCondition condition, String prefix) {
        Set patterns = condition.getPatterns();
        String[] augmentedPatterns = new String[patterns.size()];
        int count = 0;
        for (String pattern : patterns) {
            augmentedPatterns[count++] = prefix.concat(pattern);
        }
        return new PatternsRequestCondition(augmentedPatterns, this.getUrlPathHelper(), this.getPathMatcher(), this.useSuffixPatternMatch(), this.useTrailingSlashMatch(), this.getFileExtensions());
    }

    protected ProducesRequestCondition customize(ProducesRequestCondition condition) {
        return condition;
    }

    protected boolean isHandler(Class<?> beanType) {
        Class type = ClassUtils.getUserClass(beanType);
        return type.isAnnotationPresent(BasePathAwareController.class);
    }

    public void afterPropertiesSet() {
        URI baseUri = this.configuration.getBaseUri();
        if (baseUri.isAbsolute()) {
            UriAwareHttpServletRequest request = new UriAwareHttpServletRequest(this.getServletContext(), baseUri);
            this.prefix = URL_PATH_HELPER.getPathWithinApplication((HttpServletRequest)request);
        } else {
            this.prefix = baseUri.toString();
        }
        super.afterPropertiesSet();
    }

    static class CustomAcceptHeaderHttpServletRequest
    extends HttpServletRequestWrapper {
        private final List<MediaType> acceptMediaTypes;
        private final List<String> acceptMediaTypeStrings;

        public CustomAcceptHeaderHttpServletRequest(HttpServletRequest request, List<MediaType> acceptMediaTypes) {
            super(request);
            Assert.notEmpty(acceptMediaTypes, (String)"MediaTypes must not be empty!");
            this.acceptMediaTypes = acceptMediaTypes;
            ArrayList<String> acceptMediaTypeStrings = new ArrayList<String>(acceptMediaTypes.size());
            for (MediaType mediaType : acceptMediaTypes) {
                acceptMediaTypeStrings.add(mediaType.toString());
            }
            this.acceptMediaTypeStrings = acceptMediaTypeStrings;
        }

        public String getHeader(String name) {
            if ("Accept".equalsIgnoreCase(name) && this.acceptMediaTypes != null) {
                return StringUtils.collectionToCommaDelimitedString(this.acceptMediaTypes);
            }
            return super.getHeader(name);
        }

        public Enumeration<String> getHeaders(String name) {
            if ("Accept".equalsIgnoreCase(name) && this.acceptMediaTypes != null) {
                return Collections.enumeration(this.acceptMediaTypeStrings);
            }
            return super.getHeaders(name);
        }
    }

    private static class UriAwareHttpServletRequest
    implements HttpServletRequest {
        private final ServletContext context;
        private final String path;

        public UriAwareHttpServletRequest(ServletContext context, URI uri) {
            this.context = context;
            this.path = uri.getPath();
        }

        public Object getAttribute(String name) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            throw new UnsupportedOperationException();
        }

        public String getCharacterEncoding() {
            return null;
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            throw new UnsupportedOperationException();
        }

        public int getContentLength() {
            throw new UnsupportedOperationException();
        }

        public String getContentType() {
            throw new UnsupportedOperationException();
        }

        public ServletInputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getParameter(String name) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getParameterNames() {
            throw new UnsupportedOperationException();
        }

        public String[] getParameterValues(String name) {
            throw new UnsupportedOperationException();
        }

        public Map<String, String[]> getParameterMap() {
            throw new UnsupportedOperationException();
        }

        public String getProtocol() {
            throw new UnsupportedOperationException();
        }

        public String getScheme() {
            throw new UnsupportedOperationException();
        }

        public String getServerName() {
            throw new UnsupportedOperationException();
        }

        public int getServerPort() {
            throw new UnsupportedOperationException();
        }

        public BufferedReader getReader() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getRemoteAddr() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteHost() {
            throw new UnsupportedOperationException();
        }

        public void setAttribute(String name, Object o) {
            throw new UnsupportedOperationException();
        }

        public void removeAttribute(String name) {
            throw new UnsupportedOperationException();
        }

        public Locale getLocale() {
            throw new UnsupportedOperationException();
        }

        public Enumeration<Locale> getLocales() {
            throw new UnsupportedOperationException();
        }

        public boolean isSecure() {
            throw new UnsupportedOperationException();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            throw new UnsupportedOperationException();
        }

        public String getRealPath(String path) {
            throw new UnsupportedOperationException();
        }

        public int getRemotePort() {
            throw new UnsupportedOperationException();
        }

        public String getLocalName() {
            throw new UnsupportedOperationException();
        }

        public String getLocalAddr() {
            throw new UnsupportedOperationException();
        }

        public int getLocalPort() {
            throw new UnsupportedOperationException();
        }

        public ServletContext getServletContext() {
            return this.context;
        }

        public AsyncContext startAsync() throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            throw new UnsupportedOperationException();
        }

        public boolean isAsyncStarted() {
            throw new UnsupportedOperationException();
        }

        public boolean isAsyncSupported() {
            throw new UnsupportedOperationException();
        }

        public AsyncContext getAsyncContext() {
            throw new UnsupportedOperationException();
        }

        public DispatcherType getDispatcherType() {
            throw new UnsupportedOperationException();
        }

        public String getAuthType() {
            throw new UnsupportedOperationException();
        }

        public Cookie[] getCookies() {
            throw new UnsupportedOperationException();
        }

        public long getDateHeader(String name) {
            throw new UnsupportedOperationException();
        }

        public String getHeader(String name) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getHeaders(String name) {
            throw new UnsupportedOperationException();
        }

        public Enumeration<String> getHeaderNames() {
            throw new UnsupportedOperationException();
        }

        public int getIntHeader(String name) {
            throw new UnsupportedOperationException();
        }

        public String getMethod() {
            throw new UnsupportedOperationException();
        }

        public String getPathInfo() {
            throw new UnsupportedOperationException();
        }

        public String getPathTranslated() {
            throw new UnsupportedOperationException();
        }

        public String getContextPath() {
            return this.context.getContextPath();
        }

        public String getQueryString() {
            throw new UnsupportedOperationException();
        }

        public String getRemoteUser() {
            throw new UnsupportedOperationException();
        }

        public boolean isUserInRole(String role) {
            throw new UnsupportedOperationException();
        }

        public Principal getUserPrincipal() {
            throw new UnsupportedOperationException();
        }

        public String getRequestedSessionId() {
            throw new UnsupportedOperationException();
        }

        public String getRequestURI() {
            return this.path;
        }

        public StringBuffer getRequestURL() {
            throw new UnsupportedOperationException();
        }

        public String getServletPath() {
            throw new UnsupportedOperationException();
        }

        public HttpSession getSession(boolean create) {
            throw new UnsupportedOperationException();
        }

        public HttpSession getSession() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdValid() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromCookie() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromURL() {
            throw new UnsupportedOperationException();
        }

        public boolean isRequestedSessionIdFromUrl() {
            throw new UnsupportedOperationException();
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }

        public void login(String username, String password) throws ServletException {
            throw new UnsupportedOperationException();
        }

        public void logout() throws ServletException {
            throw new UnsupportedOperationException();
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }

        public Part getPart(String name) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }
    }
}

