/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.util.Assert;

public class LinkCollector {
    private final PersistentEntities entities;
    private final Associations associationLinks;
    private final SelfLinkProvider links;

    public LinkCollector(PersistentEntities entities, SelfLinkProvider linkProvider, Associations associationLinks) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)linkProvider, (String)"SelfLinkProvider must not be null!");
        Assert.notNull((Object)associationLinks, (String)"AssociationLinks must not be null!");
        this.links = linkProvider;
        this.entities = entities;
        this.associationLinks = associationLinks;
    }

    public Links getLinksFor(Object object) {
        return this.getLinksFor(object, Collections.emptyList());
    }

    public Links getLinksFor(Object object, List<Link> existingLinks) {
        Assert.notNull((Object)object, (String)"Object must not be null!");
        Assert.notNull(existingLinks, (String)"Existing links must not be null!");
        Links links = new Links(existingLinks);
        Link selfLink = this.createSelfLink(object, links);
        if (selfLink == null) {
            return links;
        }
        Path path = new Path(selfLink.expand(new Object[0]).getHref());
        LinkCollectingAssociationHandler handler = new LinkCollectingAssociationHandler(this.entities, path, this.associationLinks);
        this.entities.getRequiredPersistentEntity(object.getClass()).doWithAssociations((SimpleAssociationHandler)handler);
        ArrayList<Link> result = new ArrayList<Link>(existingLinks);
        result.addAll(handler.getLinks());
        return this.addSelfLinkIfNecessary(object, result);
    }

    public Links getLinksForNested(Object object, List<Link> existing) {
        PersistentEntity entity = this.entities.getRequiredPersistentEntity(object.getClass());
        NestedLinkCollectingAssociationHandler handler = new NestedLinkCollectingAssociationHandler(this.links, entity.getPropertyAccessor(object), this.associationLinks);
        entity.doWithAssociations((SimpleAssociationHandler)handler);
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(existing);
        links.addAll(handler.getLinks());
        return new Links(links);
    }

    private Links addSelfLinkIfNecessary(Object object, List<Link> existing) {
        Links result = new Links(existing);
        if (result.hasLink("self")) {
            return result;
        }
        ArrayList<Link> list = new ArrayList<Link>();
        list.add(this.createSelfLink(object, result));
        list.addAll(existing);
        return new Links(list);
    }

    private Link createSelfLink(Object object, Links existing) {
        if (existing.hasLink("self")) {
            return existing.getLink("self");
        }
        return this.links.createSelfLinkFor(object).withSelfRel();
    }

    private static class NestedLinkCollectingAssociationHandler
    implements SimpleAssociationHandler {
        private final SelfLinkProvider selfLinks;
        private final PersistentPropertyAccessor accessor;
        private final Associations associations;
        private final List<Link> links = new ArrayList<Link>();

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            if (!this.associations.isLinkableAssociation(association)) {
                return;
            }
            PersistentProperty property = association.getInverse();
            Object value = this.accessor.getProperty(property);
            if (value == null) {
                return;
            }
            ResourceMetadata metadata = this.associations.getMappings().getMetadataFor(property.getOwner().getType());
            ResourceMapping propertyMapping = metadata.getMappingFor(property);
            for (Object element : NestedLinkCollectingAssociationHandler.asCollection(value)) {
                if (element == null) continue;
                this.links.add(this.getLinkFor(element, propertyMapping));
            }
        }

        private Link getLinkFor(Object entity, ResourceMapping mapping) {
            return this.selfLinks.createSelfLinkFor(entity).withRel(mapping.getRel());
        }

        private static Collection<Object> asCollection(Object object) {
            if (object instanceof Collection) {
                return (Collection)object;
            }
            return Collections.singleton(object);
        }

        public NestedLinkCollectingAssociationHandler(SelfLinkProvider selfLinks, PersistentPropertyAccessor accessor, Associations associations) {
            this.selfLinks = selfLinks;
            this.accessor = accessor;
            this.associations = associations;
        }

        public List<Link> getLinks() {
            return this.links;
        }
    }

    private static class LinkCollectingAssociationHandler
    implements SimpleAssociationHandler {
        private static final String AMBIGUOUS_ASSOCIATIONS = "Detected multiple association links with same relation type! Disambiguate association %s using @RestResource!";
        @NonNull
        private final PersistentEntities entities;
        @NonNull
        private final Path basePath;
        @NonNull
        private final Associations associationLinks;
        @NonNull
        private final List<Link> links = new ArrayList<Link>();

        public List<Link> getLinks() {
            return this.links;
        }

        public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
            if (this.associationLinks.isLinkableAssociation(association)) {
                PersistentProperty property = association.getInverse();
                Links existingLinks = new Links(this.links);
                for (Link link : this.associationLinks.getLinksFor(association, this.basePath)) {
                    if (existingLinks.hasLink(link.getRel())) {
                        throw new MappingException(String.format(AMBIGUOUS_ASSOCIATIONS, property.toString()));
                    }
                    this.links.add(link);
                }
            }
        }

        public LinkCollectingAssociationHandler(@NonNull PersistentEntities entities, @NonNull Path basePath, @NonNull Associations associationLinks) {
            if (entities == null) {
                throw new IllegalArgumentException("entities is null");
            }
            if (basePath == null) {
                throw new IllegalArgumentException("basePath is null");
            }
            if (associationLinks == null) {
                throw new IllegalArgumentException("associationLinks is null");
            }
            this.entities = entities;
            this.basePath = basePath;
            this.associationLinks = associationLinks;
        }
    }
}

