/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.data.rest.core.config.JsonSchemaFormat;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class JsonSchema {
    private static List<Class<?>> INTEGER_TYPES = Arrays.asList(Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE);
    private final String title;
    private final String description;
    private final PropertiesContainer container;
    private final Descriptors descriptors;

    public JsonSchema(String title, String description, Collection<JsonSchemaProperty<?>> properties, Descriptors descriptors) {
        Assert.hasText((String)title, (String)"Title must not be null or empty!");
        Assert.notNull(properties, (String)"JsonSchemaProperties must not be null!");
        Assert.notNull((Object)descriptors, (String)"Desciptors must not be null!");
        this.title = title;
        this.description = description;
        this.container = new PropertiesContainer(properties);
        this.descriptors = descriptors;
    }

    @JsonProperty(value="$schema")
    public String getSchema() {
        return "http://json-schema.org/draft-04/schema#";
    }

    public String getType() {
        return "object";
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonUnwrapped
    public PropertiesContainer getContainer() {
        return this.container;
    }

    @JsonUnwrapped
    public Descriptors getDescriptors() {
        return this.descriptors;
    }

    private static String toJsonSchemaType(TypeInformation<?> typeInformation) {
        Class type = typeInformation.getType();
        if (type == null) {
            return null;
        }
        if (typeInformation.isCollectionLike()) {
            return "array";
        }
        if (Boolean.class.equals((Object)type) || Boolean.TYPE.equals(type)) {
            return "boolean";
        }
        if (String.class.equals((Object)type) || JsonSchema.isDate(typeInformation) || type.isEnum()) {
            return "string";
        }
        if (INTEGER_TYPES.contains(type)) {
            return "integer";
        }
        if (ClassUtils.isAssignable(Number.class, (Class)type)) {
            return "number";
        }
        return "object";
    }

    private static boolean isDate(TypeInformation<?> type) {
        Class rawType = type.getType();
        if (Date.class.equals((Object)rawType)) {
            return true;
        }
        for (String datePackage : Arrays.asList("java.time", "org.threeten.bp", "org.joda.time")) {
            if (!rawType.getName().startsWith(datePackage)) continue;
            return true;
        }
        return false;
    }

    static class EnumProperty
    extends Property {
        private final List<String> values = new ArrayList<String>();

        public EnumProperty(String name, Class<?> type, String description, boolean required) {
            super(name, description, required);
            for (Object value : type.getEnumConstants()) {
                this.values.add(value.toString());
            }
        }

        @JsonProperty(value="enum")
        public List<String> getValues() {
            return this.values;
        }
    }

    static class Property
    extends JsonSchemaProperty<Property> {
        private static final TypeInformation<?> STRING_TYPE_INFORMATION = ClassTypeInformation.from(String.class);
        public String description;
        public String type;
        public JsonSchemaFormat format;
        public String pattern;
        public Boolean uniqueItems;
        @JsonProperty(value="$ref")
        public String reference;
        public Map<String, String> items;

        public Property(String name, String description, boolean required) {
            super(name, required);
            this.description = description;
        }

        Property with(TypeInformation<?> type) {
            this.type = JsonSchema.toJsonSchemaType(type);
            if (JsonSchema.isDate(type)) {
                return this.with(JsonSchemaFormat.DATE_TIME);
            }
            if (type.isCollectionLike()) {
                if (Set.class.equals((Object)type.getType())) {
                    this.uniqueItems = true;
                }
                this.items = Collections.singletonMap("type", JsonSchema.toJsonSchemaType(type.getActualType()));
            }
            return this;
        }

        Property with(JsonSchemaFormat format) {
            this.format = format;
            return this.with(STRING_TYPE_INFORMATION);
        }

        Property with(Pattern pattern) {
            this.pattern = pattern.toString();
            return this.with(STRING_TYPE_INFORMATION);
        }

        Property with(TypeInformation<?> type, String reference) {
            if (type.isCollectionLike()) {
                if (Set.class.equals((Object)type.getType())) {
                    this.uniqueItems = true;
                }
                this.type = JsonSchema.toJsonSchemaType(type);
                this.items = Collections.singletonMap("$ref", reference);
                return this;
            }
            this.reference = reference;
            return this;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static abstract class JsonSchemaProperty<T extends JsonSchemaProperty<T>> {
        private final String name;
        private final boolean required;
        private boolean readOnly;

        protected JsonSchemaProperty(String name, boolean required) {
            this.name = name;
            this.required = required;
            this.readOnly = false;
        }

        @JsonIgnore
        public String getName() {
            return this.name;
        }

        private boolean isRequired() {
            return this.required;
        }

        public boolean isReadOnly() {
            return this.readOnly;
        }

        protected T withReadOnly() {
            this.readOnly = true;
            return (T)this;
        }
    }

    static class Descriptors {
        private final Map<String, Item> descriptors = new HashMap<String, Item>();

        public Map<String, Item> getDescriptors() {
            return this.descriptors;
        }

        boolean hasDescriptorFor(TypeInformation<?> type) {
            return this.descriptors.containsKey(Descriptors.typeKey(type));
        }

        String addDescriptor(TypeInformation<?> type, Item item) {
            String reference = Descriptors.typeKey(type);
            this.descriptors.put(reference, item);
            return reference;
        }

        static String getReference(TypeInformation<?> type) {
            return String.format("#/descriptors/%s", Descriptors.typeKey(type));
        }

        static String typeKey(TypeInformation<?> type) {
            return StringUtils.uncapitalize((String)type.getActualType().getType().getSimpleName());
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class PropertiesContainer {
        public final Map<String, JsonSchemaProperty<?>> properties;
        public final Collection<String> requiredProperties;

        public PropertiesContainer(Collection<JsonSchemaProperty<?>> properties) {
            Assert.notNull(properties, (String)"JsonSchemaPropertys must not be null!");
            this.properties = new HashMap();
            this.requiredProperties = new ArrayList<String>();
            for (JsonSchemaProperty<?> property : properties) {
                this.properties.put(property.getName(), property);
                if (!((JsonSchemaProperty)property).isRequired()) continue;
                this.requiredProperties.add(((JsonSchemaProperty)property).name);
            }
        }
    }

    static class Item {
        private final String type;
        private final PropertiesContainer properties;

        public Item(TypeInformation<?> type, Collection<JsonSchemaProperty<?>> properties) {
            this.type = JsonSchema.toJsonSchemaType(type);
            this.properties = new PropertiesContainer(properties);
        }

        public String getType() {
            return this.type;
        }

        @JsonUnwrapped
        public PropertiesContainer getProperties() {
            return this.properties;
        }
    }
}

