/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.Calendar;
import org.springframework.data.auditing.AuditableBeanWrapper;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class AbstractRepositoryRestController {
    private final PagedResourcesAssembler<Object> pagedResourcesAssembler;
    private final AuditableBeanWrapperFactory auditableBeanWrapperFactory;

    public AbstractRepositoryRestController(PagedResourcesAssembler<Object> pagedResourcesAssembler, AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        Assert.notNull(pagedResourcesAssembler, (String)"PagedResourcesAssembler must not be null!");
        Assert.notNull((Object)auditableBeanWrapperFactory, (String)"AuditableBeanWrapperFactory must not be null!");
        this.pagedResourcesAssembler = pagedResourcesAssembler;
        this.auditableBeanWrapperFactory = auditableBeanWrapperFactory;
    }

    protected Link resourceLink(RootResourceInformation resourceLink, Resource resource) {
        ResourceMetadata repoMapping = resourceLink.getResourceMetadata();
        Link selfLink = resource.getLink("self");
        String rel = repoMapping.getItemResourceRel();
        return new Link(selfLink.getHref(), rel);
    }

    protected Resources<?> toResources(Iterable<?> source, PersistentEntityResourceAssembler assembler, Link baseLink) {
        if (source instanceof Page) {
            Page page = (Page)source;
            return this.entitiesToResources((Page<Object>)page, assembler, baseLink);
        }
        if (source instanceof Iterable) {
            return this.entitiesToResources(source, assembler);
        }
        return new Resources(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]);
    }

    protected Object toResource(Object source, PersistentEntityResourceAssembler assembler, Link baseLink) {
        if (source instanceof Iterable) {
            return this.toResources((Iterable)source, assembler, baseLink);
        }
        if (source == null || ClassUtils.isPrimitiveOrWrapper(source.getClass())) {
            return source;
        }
        return assembler.toFullResource(source);
    }

    protected Resources<? extends Resource<Object>> entitiesToResources(Page<Object> page, PersistentEntityResourceAssembler assembler, Link baseLink) {
        return baseLink == null ? this.pagedResourcesAssembler.toResource(page, (ResourceAssembler)assembler) : this.pagedResourcesAssembler.toResource(page, (ResourceAssembler)assembler, baseLink);
    }

    protected Resources<Resource<Object>> entitiesToResources(Iterable<Object> entities, PersistentEntityResourceAssembler assembler) {
        ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
        for (Object obj : entities) {
            resources.add(obj == null ? null : assembler.toResource(obj));
        }
        return new Resources(resources, new Link[0]);
    }

    protected HttpHeaders prepareHeaders(PersistentEntityResource resource) {
        return resource == null ? new HttpHeaders() : this.prepareHeaders(resource.getPersistentEntity(), resource.getContent());
    }

    protected HttpHeaders prepareHeaders(PersistentEntity<?, ?> entity, Object value) {
        HttpHeaders headers = ETag.from(entity, value).addTo(new HttpHeaders());
        AuditableBeanWrapper wrapper = this.getAuditableBeanWrapper(value);
        if (wrapper == null) {
            return headers;
        }
        Calendar lastModifiedDate = wrapper.getLastModifiedDate();
        if (lastModifiedDate != null) {
            headers.setLastModified(lastModifiedDate.getTimeInMillis());
        }
        return headers;
    }

    protected AuditableBeanWrapper getAuditableBeanWrapper(Object source) {
        return this.auditableBeanWrapperFactory.getBeanWrapperFor(source);
    }
}

