/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.Collections;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.mapping.PropertyMappings;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;

public class AssociationLinks {
    private final ResourceMappings mappings;
    private final PropertyMappings propertyMappings;

    public AssociationLinks(ResourceMappings mappings) {
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.propertyMappings = new PropertyMappings(mappings);
        this.mappings = mappings;
    }

    public List<Link> getLinksFor(Association<? extends PersistentProperty<?>> association, Path path) {
        Assert.notNull(association, (String)"Association must not be null!");
        Assert.notNull((Object)path, (String)"Base path must not be null!");
        PersistentProperty property = association.getInverse();
        if (this.isLinkableAssociation(property)) {
            ResourceMapping propertyMapping = this.propertyMappings.getMappingFor(property);
            String href = path.slash(propertyMapping.getPath()).toString();
            String rel = propertyMapping.getRel();
            return Collections.singletonList(new Link(href, rel));
        }
        return Collections.emptyList();
    }

    public boolean isLinkableAssociation(PersistentProperty<?> property) {
        if (property == null || !property.isAssociation()) {
            return false;
        }
        ResourceMetadata metadata = this.mappings.getMappingFor(property.getOwner().getType());
        if (metadata != null && !metadata.isExported(property)) {
            return false;
        }
        metadata = this.mappings.getMappingFor(property.getActualType());
        return metadata == null ? false : metadata.isExported();
    }
}

