/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;

public class DomainObjectReader {
    private final PersistentEntities entities;
    private final AssociationLinks associationLinks;
    private final ClassIntrospector introspector;

    public DomainObjectReader(PersistentEntities entities, ResourceMappings mappings) {
        Assert.notNull((Object)entities, (String)"PersistentEntites must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.entities = entities;
        this.associationLinks = new AssociationLinks(mappings);
        this.introspector = new BasicClassIntrospector();
    }

    public <T> T read(InputStream source, T target, ObjectMapper mapper) {
        Assert.notNull(target, (String)"Target object must not be null!");
        Assert.notNull((Object)source, (String)"InputStream must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        try {
            return this.merge((ObjectNode)mapper.readTree(source), target, mapper);
        }
        catch (Exception e) {
            throw new HttpMessageNotReadableException("Could not read payload!", (Throwable)e);
        }
    }

    public <T> T merge(ObjectNode root, T existingObject, ObjectMapper mapper) throws Exception {
        Assert.notNull((Object)root, (String)"Root ObjectNode must not be null!");
        Assert.notNull(existingObject, (String)"Existing object instance must not be null!");
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Iterator i = root.fields();
        while (i.hasNext()) {
            BeanWrapper wrapper;
            Object nested;
            PersistentProperty<?> property;
            Map.Entry entry = (Map.Entry)i.next();
            JsonNode child = (JsonNode)entry.getValue();
            if (child.isArray() || !child.isObject() || (property = this.findProperty(existingObject, (String)entry.getKey(), mapper)) == null || this.associationLinks.isLinkableAssociation(property) || (nested = (wrapper = BeanWrapper.create(existingObject, null)).getProperty(property)) == null) continue;
            i.remove();
            this.merge((ObjectNode)child, nested, mapper);
        }
        ObjectReader jsonReader = mapper.readerForUpdating(existingObject);
        jsonReader.readValue((JsonNode)root);
        return existingObject;
    }

    private PersistentProperty<?> findProperty(Object object, String fieldName, ObjectMapper mapper) {
        PersistentEntity entity = this.entities.getPersistentEntity(object.getClass());
        if (entity == null) {
            return null;
        }
        BeanDescription description = this.introspector.forDeserialization(mapper.getDeserializationConfig(), mapper.constructType(object.getClass()), (ClassIntrospector.MixInResolver)mapper.getDeserializationConfig());
        for (BeanPropertyDefinition definition : description.findProperties()) {
            if (!definition.getName().equals(fieldName)) continue;
            return entity.getPersistentProperty(definition.getInternalName());
        }
        return null;
    }
}

