/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.support.RepositoryLinkBuilder;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.core.AbstractEntityLinks;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryEntityLinks
extends AbstractEntityLinks {
    private final Repositories repositories;
    private final ResourceMappings mappings;
    private final RepositoryRestConfiguration config;
    private final HateoasPageableHandlerMethodArgumentResolver resolver;

    @Autowired
    public RepositoryEntityLinks(Repositories repositories, ResourceMappings mappings, RepositoryRestConfiguration config, HateoasPageableHandlerMethodArgumentResolver resolver) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        Assert.notNull((Object)resolver, (String)"HateoasPageableHandlerMethodArgumentResolver must not be null!");
        this.repositories = repositories;
        this.mappings = mappings;
        this.config = config;
        this.resolver = resolver;
    }

    public boolean supports(Class<?> delimiter) {
        return this.repositories.hasRepositoryFor(delimiter);
    }

    public LinkBuilder linkFor(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        return new RepositoryLinkBuilder(metadata, this.config.getBaseUri());
    }

    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.linkFor(type);
    }

    public Link linkToCollectionResource(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        if (metadata.isPagingResource()) {
            Link link = this.linkFor(type).withSelfRel();
            String href = link.getHref();
            UriComponents components = UriComponentsBuilder.fromUriString((String)href).build();
            TemplateVariables variables = this.resolver.getPaginationTemplateVariables(null, components);
            return new Link(new UriTemplate(href, variables), metadata.getRel());
        }
        return this.linkFor(type).withRel(metadata.getRel());
    }

    public Link linkToSingleResource(Class<?> type, Object id) {
        ResourceMetadata metadata = this.mappings.getMappingFor(type);
        return this.linkFor(type).slash(id).withRel(metadata.getItemResourceRel());
    }
}

