/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.io.Serializable;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.rest.webmvc.util.UriUtils;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class BackendIdHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver;

    public BackendIdHandlerMethodArgumentResolver(ResourceMetadataHandlerMethodArgumentResolver resourceMetadataResolver) {
        Assert.notNull((Object)resourceMetadataResolver, (String)"ResourceMetadata resolver must not be null!");
        this.resourceMetadataResolver = resourceMetadataResolver;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(BackendId.class);
    }

    public String resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        Class parameterType = parameter.getParameterType();
        if (!parameterType.equals(Serializable.class)) {
            throw new IllegalArgumentException(String.format("Method parameter for @%s must be of type %s! Got %s for method %s.", BackendId.class.getSimpleName(), Serializable.class.getSimpleName(), parameterType.getSimpleName(), parameter.getMethod()));
        }
        ResourceMetadata metadata = this.resourceMetadataResolver.resolveArgument(parameter, mavContainer, request, binderFactory);
        if (metadata == null) {
            throw new IllegalArgumentException("Could not obtain ResourceMetadata for request " + request);
        }
        return UriUtils.findMappingVariable("id", parameter, request);
    }
}

