/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.repository.RepositoryExporter;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.json.JsonSchemaController;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RepositoryRestHandlerMapping
extends RequestMappingHandlerMapping {
    @Autowired
    private EntityManagerFactory entityManagerFactory;
    @Autowired(required=false)
    private List<RepositoryExporter> repositoryExporters = Collections.emptyList();
    private Set<String> repositoryNames = new HashSet<String>();

    public RepositoryRestHandlerMapping() {
        this.setOrder(Integer.MIN_VALUE);
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        String[] parts;
        if (this.repositoryNames.isEmpty() && !this.repositoryExporters.isEmpty()) {
            for (RepositoryExporter re : this.repositoryExporters) {
                this.repositoryNames.addAll(re.repositoryNames());
            }
        }
        if ((parts = lookupPath.split("/")).length == 0) {
            return super.lookupHandlerMethod(lookupPath, request);
        }
        if (this.repositoryNames.contains(parts[1])) {
            return super.lookupHandlerMethod(lookupPath, request);
        }
        return null;
    }

    protected boolean isHandler(Class<?> beanType) {
        return RepositoryRestController.class.isAssignableFrom(beanType) || JsonSchemaController.class.isAssignableFrom(beanType);
    }

    protected void extendInterceptors(List<Object> interceptors) {
        if (null != this.entityManagerFactory) {
            OpenEntityManagerInViewInterceptor omivi = new OpenEntityManagerInViewInterceptor();
            omivi.setEntityManagerFactory(this.entityManagerFactory);
            interceptors.add(omivi);
        }
    }
}

