/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.Between;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Conditions;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.IsNull;
import org.springframework.data.relational.core.sql.Like;
import org.springframework.data.relational.core.sql.Named;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Column
extends AbstractSegment
implements Expression,
Named {
    private final SqlIdentifier name;
    private final @Nullable TableLike table;

    Column(String name, @Nullable TableLike table) {
        Segment[] segmentArray;
        if (table == null) {
            segmentArray = new Segment[]{};
        } else {
            Segment[] segmentArray2 = new Segment[1];
            segmentArray = segmentArray2;
            segmentArray2[0] = table;
        }
        super(segmentArray);
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = SqlIdentifier.unquoted(name);
        this.table = table;
    }

    Column(SqlIdentifier name, @Nullable TableLike table) {
        Segment[] segmentArray;
        if (table == null) {
            segmentArray = new Segment[]{};
        } else {
            Segment[] segmentArray2 = new Segment[1];
            segmentArray = segmentArray2;
            segmentArray2[0] = table;
        }
        super(segmentArray);
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.table = table;
    }

    public static Column create(String name, TableLike table) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull((Object)table, (String)"Table must not be null");
        return new Column(SqlIdentifier.unquoted(name), table);
    }

    public static Column create(SqlIdentifier name, Table table) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        Assert.notNull((Object)table, (String)"Table must not be null");
        return new Column(name, (TableLike)table);
    }

    public static Column aliased(String name, Table table, String alias) {
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull((Object)table, (String)"Table must not be null");
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedColumn(name, (TableLike)table, alias);
    }

    public Column as(String alias) {
        Assert.hasText((String)alias, (String)"Alias must not be null or empty");
        return new AliasedColumn(this.name, this.table, SqlIdentifier.unquoted(alias));
    }

    public Column as(SqlIdentifier alias) {
        Assert.notNull((Object)alias, (String)"Alias must not be null");
        return new AliasedColumn(this.name, this.table, alias);
    }

    public Column from(Table table) {
        Assert.notNull((Object)table, (String)"Table must not be null");
        return new Column(this.name, (TableLike)table);
    }

    public Comparison isEqualTo(Expression expression) {
        return Conditions.isEqual(this, expression);
    }

    public Comparison isNotEqualTo(Expression expression) {
        return Conditions.isNotEqual(this, expression);
    }

    public Between between(Expression begin, Expression end) {
        return Conditions.between(this, begin, end);
    }

    public Between notBetween(Expression begin, Expression end) {
        return Conditions.notBetween(this, begin, end);
    }

    public Comparison isLess(Expression expression) {
        return Conditions.isLess(this, expression);
    }

    public Comparison isLessOrEqualTo(Expression expression) {
        return Conditions.isLessOrEqualTo(this, expression);
    }

    public Comparison isGreater(Expression expression) {
        return Conditions.isGreater(this, expression);
    }

    public Comparison isGreaterOrEqualTo(Expression expression) {
        return Conditions.isGreaterOrEqualTo(this, expression);
    }

    public Like like(Expression expression) {
        return Conditions.like(this, expression);
    }

    public Like notLike(Expression expression) {
        return Conditions.notLike(this, expression);
    }

    public In in(Expression ... expression) {
        return Conditions.in((Expression)this, expression);
    }

    public In in(Select subselect) {
        return Conditions.in((Expression)this, subselect);
    }

    public In notIn(Expression ... expression) {
        return Conditions.notIn((Expression)this, expression);
    }

    public In notIn(Select subselect) {
        return Conditions.notIn(this, subselect);
    }

    public IsNull isNull() {
        return Conditions.isNull(this);
    }

    public Condition isNotNull() {
        return this.isNull().not();
    }

    public AssignValue set(Expression value) {
        return Assignments.value(this, value);
    }

    @Override
    public SqlIdentifier getName() {
        return this.name;
    }

    public SqlIdentifier getReferenceName() {
        return this.getName();
    }

    public @Nullable TableLike getTable() {
        return this.table;
    }

    public TableLike getRequiredTable() {
        TableLike table = this.getTable();
        if (table == null) {
            throw new IllegalStateException("Column '%s' is not associated with a Table".formatted(this.getName()));
        }
        return table;
    }

    @Override
    public String toString() {
        return this.getPrefix() + String.valueOf(this.name);
    }

    String getPrefix() {
        Object prefix = "";
        if (this.table != null) {
            prefix = String.valueOf(this.table instanceof Aliased ? ((Aliased)((Object)this.table)).getAlias() : this.table.getName()) + ".";
        }
        return prefix;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Column column = (Column)o;
        return this.name.equals(column.name) && ObjectUtils.nullSafeEquals((Object)this.table, (Object)column.table);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.table);
    }

    static class AliasedColumn
    extends Column
    implements Aliased {
        private final SqlIdentifier alias;

        private AliasedColumn(String name, @Nullable TableLike table, String alias) {
            super(name, table);
            this.alias = SqlIdentifier.unquoted(alias);
        }

        private AliasedColumn(SqlIdentifier name, @Nullable TableLike table, SqlIdentifier alias) {
            super(name, table);
            this.alias = alias;
        }

        @Override
        public SqlIdentifier getAlias() {
            return this.alias;
        }

        @Override
        public SqlIdentifier getReferenceName() {
            return this.getAlias();
        }

        @Override
        public Column from(Table table) {
            Assert.notNull((Object)table, (String)"Table must not be null");
            return new AliasedColumn(this.getName(), (TableLike)table, this.getAlias());
        }

        @Override
        public String toString() {
            return this.getPrefix() + String.valueOf(this.getName()) + " AS " + String.valueOf(this.getAlias());
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AliasedColumn that = (AliasedColumn)o;
            return this.alias.equals(that.alias);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.alias);
        }
    }
}

