/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.dialect.ObjectArrayColumns;
import org.springframework.data.relational.core.dialect.TimestampAtUtcToOffsetDateTimeConverter;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.SimpleFunction;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.TableLike;

public class PostgresDialect
extends AbstractDialect {
    public static final PostgresDialect INSTANCE = new PostgresDialect();
    private static final Set<Class<?>> POSTGRES_SIMPLE_TYPES = Set.of(UUID.class, URL.class, URI.class, InetAddress.class, Map.class);
    private IdentifierProcessing identifierProcessing = IdentifierProcessing.create(IdentifierProcessing.Quoting.ANSI, IdentifierProcessing.LetterCasing.LOWER_CASE);
    private IdGeneration idGeneration = new IdGeneration(){

        @Override
        public String createSequenceQuery(SqlIdentifier sequenceName) {
            return "SELECT nextval('%s')".formatted(sequenceName.toSql(PostgresDialect.this.getIdentifierProcessing()));
        }
    };
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %d OFFSET %d", limit, offset);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private static final ObjectArrayColumns ARRAY_COLUMNS = ObjectArrayColumns.INSTANCE;
    private final PostgresLockClause LOCK_CLAUSE = new PostgresLockClause(this.getIdentifierProcessing());

    protected PostgresDialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return this.LOCK_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return ARRAY_COLUMNS;
    }

    @Override
    public Collection<Object> getConverters() {
        return Collections.singletonList(TimestampAtUtcToOffsetDateTimeConverter.INSTANCE);
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return this.identifierProcessing;
    }

    @Override
    public Set<Class<?>> simpleTypes() {
        return POSTGRES_SIMPLE_TYPES;
    }

    @Override
    public SimpleFunction getExistsFunction() {
        return Functions.least(Functions.count(SQL.literalOf(1)), SQL.literalOf(1));
    }

    @Override
    public IdGeneration getIdGeneration() {
        return this.idGeneration;
    }

    static class PostgresLockClause
    implements LockClause {
        private final IdentifierProcessing identifierProcessing;

        PostgresLockClause(IdentifierProcessing identifierProcessing) {
            this.identifierProcessing = identifierProcessing;
        }

        @Override
        public String getLock(LockOptions lockOptions) {
            SqlIdentifier identifier;
            List<TableLike> tables = lockOptions.getFrom().getTables();
            if (tables.isEmpty()) {
                return "";
            }
            SqlIdentifier last = identifier = tables.get(0).getName();
            Iterator iterator = identifier.iterator();
            while (iterator.hasNext()) {
                SqlIdentifier sqlIdentifier;
                last = sqlIdentifier = (SqlIdentifier)iterator.next();
            }
            String tableName = last.toSql(this.identifierProcessing);
            return switch (lockOptions.getLockMode()) {
                default -> throw new IncompatibleClassChangeError();
                case LockMode.PESSIMISTIC_WRITE -> "FOR UPDATE OF " + tableName;
                case LockMode.PESSIMISTIC_READ -> "FOR SHARE OF " + tableName;
            };
        }

        @Override
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    }
}

