/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.InlineQuery;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.NameRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.SelectStatementVisitor;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class FromTableVisitor
extends TypedSubtreeVisitor<TableLike> {
    private final RenderContext context;
    private final RenderTarget parent;
    @Nullable
    private SelectStatementVisitor delegate;
    @Nullable
    private StringBuilder builder = null;

    FromTableVisitor(RenderContext context, RenderTarget parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(TableLike segment) {
        this.builder = new StringBuilder();
        if (segment instanceof InlineQuery) {
            this.builder.append("(");
            this.delegate = new SelectStatementVisitor(this.context);
            return DelegatingVisitor.Delegation.delegateTo(this.delegate);
        }
        return super.enterMatched(segment);
    }

    @Override
    DelegatingVisitor.Delegation leaveMatched(TableLike segment) {
        Assert.state((this.builder != null ? 1 : 0) != 0, (String)"Builder must not be null in leaveMatched");
        if (this.delegate != null) {
            this.builder.append(this.delegate.getRenderedPart());
            this.builder.append(") ");
            this.delegate = null;
        }
        this.builder.append(NameRenderer.render(this.context, segment));
        if (segment instanceof Aliased) {
            this.builder.append(" ").append(NameRenderer.render(this.context, (Aliased)((Object)segment)));
        }
        this.parent.onRendered(this.builder);
        return super.leaveMatched(segment);
    }
}

