/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.UnaryOperator;
import org.springframework.data.relational.core.sql.CompositeSqlIdentifier;
import org.springframework.data.relational.core.sql.DefaultSqlIdentifier;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.util.Streamable;

public interface SqlIdentifier
extends Streamable<SqlIdentifier> {
    public static final SqlIdentifier EMPTY = new SqlIdentifier(){

        public Iterator<SqlIdentifier> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public SqlIdentifier transform(UnaryOperator<String> transformationFunction) {
            return this;
        }

        @Override
        public String toSql(IdentifierProcessing processing) {
            throw new UnsupportedOperationException("An empty SqlIdentifier can't be used in to create SQL snippets");
        }

        @Override
        public String getReference(IdentifierProcessing processing) {
            throw new UnsupportedOperationException("An empty SqlIdentifier can't be used in to create column names");
        }

        public String toString() {
            return "<NULL-IDENTIFIER>";
        }
    };

    public String getReference(IdentifierProcessing var1);

    default public String getReference() {
        return this.getReference(IdentifierProcessing.NONE);
    }

    public String toSql(IdentifierProcessing var1);

    public SqlIdentifier transform(UnaryOperator<String> var1);

    public static SqlIdentifier quoted(String name) {
        return new DefaultSqlIdentifier(name, true);
    }

    public static SqlIdentifier unquoted(String name) {
        return new DefaultSqlIdentifier(name, false);
    }

    public static SqlIdentifier from(SqlIdentifier ... sqlIdentifiers) {
        return new CompositeSqlIdentifier(sqlIdentifiers);
    }
}

