/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.ArrayColumns;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockOptions;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AnsiDialect
extends AbstractDialect {
    public static final AnsiDialect INSTANCE = new AnsiDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return String.format("FETCH FIRST %d ROWS ONLY", limit);
        }

        @Override
        public String getOffset(long offset) {
            return String.format("OFFSET %d ROWS", offset);
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH FIRST %d ROWS ONLY", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    static final LockClause LOCK_CLAUSE = new LockClause(){

        @Override
        public String getLock(LockOptions lockOptions) {
            return "FOR UPDATE";
        }

        @Override
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    };
    private final AnsiArrayColumns ARRAY_COLUMNS = new AnsiArrayColumns();

    protected AnsiDialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public LockClause lock() {
        return LOCK_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return this.ARRAY_COLUMNS;
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return IdentifierProcessing.ANSI;
    }

    static class AnsiArrayColumns
    implements ArrayColumns {
        AnsiArrayColumns() {
        }

        @Override
        public boolean isSupported() {
            return true;
        }

        @Override
        public Class<?> getArrayType(Class<?> userType) {
            Assert.notNull(userType, (String)"Array component type must not be null");
            return ClassUtils.resolvePrimitiveIfNecessary(userType);
        }
    }
}

