/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.function.UnaryOperator;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.util.Assert;

class DefaultSqlIdentifier
implements SqlIdentifier {
    private final String name;
    private final boolean quoted;

    DefaultSqlIdentifier(String name, boolean quoted) {
        Assert.hasText((String)name, (String)"A database object name must not be null or empty");
        this.name = name;
        this.quoted = quoted;
    }

    @Override
    public SqlIdentifier transform(UnaryOperator<String> transformationFunction) {
        Assert.notNull(transformationFunction, (String)"Transformation function must not be null");
        return new DefaultSqlIdentifier((String)transformationFunction.apply(this.name), this.quoted);
    }

    @Override
    public String toSql(IdentifierProcessing processing) {
        return this.quoted ? processing.quote(this.getReference(processing)) : this.getReference(processing);
    }

    @Override
    public String getReference(IdentifierProcessing processing) {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SqlIdentifier) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.quoted) {
            return this.toSql(IdentifierProcessing.ANSI);
        }
        return this.name;
    }
}

