/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.SqlServerSelectRenderContext;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.data.util.Lazy;

public class SqlServerDialect
extends AbstractDialect {
    public static final SqlServerDialect INSTANCE = new SqlServerDialect();
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "OFFSET 0 ROWS FETCH NEXT " + limit + " ROWS ONLY";
        }

        @Override
        public String getOffset(long offset) {
            return "OFFSET " + offset + " ROWS";
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("OFFSET %d ROWS FETCH NEXT %d ROWS ONLY", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };
    private final Lazy<SelectRenderContext> selectRenderContext = Lazy.of(() -> new SqlServerSelectRenderContext(this.getAfterOrderBy()));

    protected SqlServerDialect() {
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public Escaper getLikeEscaper() {
        return Escaper.DEFAULT.withRewriteFor("[", "]");
    }

    @Override
    public SelectRenderContext getSelectContext() {
        return (SelectRenderContext)this.selectRenderContext.get();
    }
}

