/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.util.Assert;

public class MySqlDialect
extends AbstractDialect {
    public static final IdentifierProcessing MYSQL_IDENTIFIER_PROCESSING = IdentifierProcessing.create(new IdentifierProcessing.Quoting("`"), IdentifierProcessing.LetterCasing.LOWER_CASE);
    public static final MySqlDialect INSTANCE = new MySqlDialect();
    private final IdentifierProcessing identifierProcessing;
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public String getOffset(long offset) {
            return String.format("LIMIT %d, 18446744073709551615", offset);
        }

        @Override
        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %s, %s", offset, limit);
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    };

    protected MySqlDialect() {
        this(MYSQL_IDENTIFIER_PROCESSING);
    }

    public MySqlDialect(IdentifierProcessing identifierProcessing) {
        Assert.notNull((Object)identifierProcessing, (String)"IdentifierProcessing must not be null");
        this.identifierProcessing = identifierProcessing;
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public IdentifierProcessing getIdentifierProcessing() {
        return this.identifierProcessing;
    }
}

