/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Not;
import org.springframework.util.Assert;

public class Comparison
extends AbstractSegment
implements Condition {
    private final Expression left;
    private final String comparator;
    private final Expression right;

    private Comparison(Expression left, String comparator, Expression right) {
        super(left, right);
        this.left = left;
        this.comparator = comparator;
        this.right = right;
    }

    public static Comparison create(Expression leftColumnOrExpression, String comparator, Expression rightColumnOrExpression) {
        Assert.notNull((Object)leftColumnOrExpression, (String)"Left expression must not be null!");
        Assert.notNull((Object)comparator, (String)"Comparator must not be null!");
        Assert.notNull((Object)rightColumnOrExpression, (String)"Right expression must not be null!");
        return new Comparison(leftColumnOrExpression, comparator, rightColumnOrExpression);
    }

    @Override
    public Condition not() {
        if ("=".equals(this.comparator)) {
            return new Comparison(this.left, "!=", this.right);
        }
        if ("!=".equals(this.comparator)) {
            return new Comparison(this.left, "=", this.right);
        }
        return new Not(this);
    }

    public Expression getLeft() {
        return this.left;
    }

    public String getComparator() {
        return this.comparator;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public String toString() {
        return this.left.toString() + " " + this.comparator + " " + this.right.toString();
    }
}

