/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.RenderTarget;
import org.springframework.data.relational.core.sql.render.TypedSubtreeVisitor;

class FromTableVisitor
extends TypedSubtreeVisitor<Table> {
    private final RenderContext context;
    private final RenderTarget parent;

    FromTableVisitor(RenderContext context, RenderTarget parent) {
        this.context = context;
        this.parent = parent;
    }

    @Override
    DelegatingVisitor.Delegation enterMatched(Table segment) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.context.getNamingStrategy().getName(segment));
        if (segment instanceof Aliased) {
            builder.append(" AS ").append(((Aliased)((Object)segment)).getAlias());
        }
        this.parent.onRendered(builder);
        return super.enterMatched(segment);
    }
}

