/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.core.CollectionFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class SerializationUtils {
    static final byte[] EMPTY_ARRAY = new byte[0];

    @Contract(value="null -> true")
    static boolean isEmpty(byte @Nullable [] data) {
        return data == null || data.length == 0;
    }

    static <T extends Collection<?>> T deserializeValues(@Nullable Collection<byte[]> rawValues, Class<T> type, @Nullable RedisSerializer<?> redisSerializer) {
        if (CollectionUtils.isEmpty(rawValues)) {
            return (T)CollectionFactory.createCollection(type, (int)0);
        }
        Assert.notNull(redisSerializer, (String)"RedisSerializer must not be null");
        AbstractCollection values = List.class.isAssignableFrom(type) ? new ArrayList(rawValues.size()) : new LinkedHashSet(rawValues.size());
        for (byte[] bs : rawValues) {
            values.add(redisSerializer.deserialize(bs));
        }
        return (T)values;
    }

    public static <T> Set<T> deserialize(@Nullable Set<byte[]> rawValues, @Nullable RedisSerializer<T> redisSerializer) {
        return SerializationUtils.deserializeValues(rawValues, Set.class, redisSerializer);
    }

    public static <T> List<T> deserialize(@Nullable List<byte[]> rawValues, @Nullable RedisSerializer<T> redisSerializer) {
        return SerializationUtils.deserializeValues(rawValues, List.class, redisSerializer);
    }

    public static <T> Collection<T> deserialize(@Nullable Collection<byte[]> rawValues, RedisSerializer<T> redisSerializer) {
        return SerializationUtils.deserializeValues(rawValues, List.class, redisSerializer);
    }

    public static <T> Map<T, @Nullable T> deserialize(@Nullable Map<byte[], byte[]> rawValues, RedisSerializer<T> redisSerializer) {
        if (CollectionUtils.isEmpty(rawValues)) {
            return Collections.emptyMap();
        }
        Assert.notNull(redisSerializer, (String)"RedisSerializer must not be null");
        LinkedHashMap<T, @Nullable T> ret = new LinkedHashMap<T, T>(rawValues.size());
        for (Map.Entry<byte[], byte[]> entry : rawValues.entrySet()) {
            ret.put(redisSerializer.deserialize(entry.getKey()), redisSerializer.deserialize(entry.getValue()));
        }
        return ret;
    }

    public static <HK, HV> Map<HK, HV> deserialize(@Nullable Map<byte[], byte[]> rawValues, @Nullable RedisSerializer<HK> hashKeySerializer, @Nullable RedisSerializer<HV> hashValueSerializer) {
        if (CollectionUtils.isEmpty(rawValues)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>(rawValues.size());
        for (Map.Entry<byte[], byte[]> entry : rawValues.entrySet()) {
            byte[] key = hashKeySerializer != null ? (Object)hashKeySerializer.deserialize(entry.getKey()) : entry.getKey();
            byte[] value = hashValueSerializer != null ? (Object)hashValueSerializer.deserialize(entry.getValue()) : entry.getValue();
            map.put(key, value);
        }
        return map;
    }
}

