/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisPassword {
    private static final RedisPassword NONE = new RedisPassword(new char[0]);
    private final char[] thePassword;

    private RedisPassword(char[] thePassword) {
        this.thePassword = thePassword;
    }

    public static RedisPassword of(@Nullable String passwordAsString) {
        if (!StringUtils.hasText((String)passwordAsString)) {
            return RedisPassword.none();
        }
        return new RedisPassword(passwordAsString.toCharArray());
    }

    public static RedisPassword of(char @Nullable [] passwordAsChars) {
        if (ObjectUtils.isEmpty((Object)passwordAsChars)) {
            return RedisPassword.none();
        }
        return new RedisPassword(Arrays.copyOf(passwordAsChars, passwordAsChars.length));
    }

    public static RedisPassword none() {
        return NONE;
    }

    public boolean isPresent() {
        return !ObjectUtils.isEmpty((Object)this.thePassword);
    }

    public char[] get() throws NoSuchElementException {
        if (this.isPresent()) {
            return Arrays.copyOf(this.thePassword, this.thePassword.length);
        }
        throw new NoSuchElementException("No password present.");
    }

    public <R> Optional<R> map(Function<char[], R> mapper) {
        Assert.notNull(mapper, (String)"Mapper function must not be null");
        return this.toOptional().map(mapper);
    }

    public Optional<char[]> toOptional() {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisPassword password = (RedisPassword)o;
        return ObjectUtils.nullSafeEquals((Object)this.thePassword, (Object)password.thePassword);
    }

    public int hashCode() {
        return Objects.hashCode(this.thePassword);
    }

    public String toString() {
        return "%s[%s]".formatted(this.getClass().getSimpleName(), this.isPresent() ? "*****" : "<none>");
    }
}

