/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;

@NullUnmarked
public interface GeoOperations<K, M> {
    public Long add(@NonNull K var1, @NonNull Point var2, @NonNull M var3);

    public Long add(@NonNull K var1,  @NonNull RedisGeoCommands.GeoLocation<M> var2);

    public Long add(@NonNull K var1, @NonNull Map<@NonNull M, @NonNull Point> var2);

    public Long add(@NonNull K var1, @NonNull Iterable< @NonNull RedisGeoCommands.GeoLocation<M>> var2);

    public Distance distance(@NonNull K var1, @NonNull M var2, @NonNull M var3);

    public Distance distance(@NonNull K var1, @NonNull M var2, @NonNull M var3, @NonNull Metric var4);

    public List<String> hash(@NonNull K var1, M ... var2);

    public List<Point> position(@NonNull K var1, M ... var2);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull K var1, @NonNull Circle var2);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull K var1, @NonNull Circle var2,  @NonNull RedisGeoCommands.GeoRadiusCommandArgs var3);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull K var1, @NonNull M var2, double var3);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull K var1, @NonNull M var2, @NonNull Distance var3);

    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(@NonNull K var1, @NonNull M var2, @NonNull Distance var3,  @NonNull RedisGeoCommands.GeoRadiusCommandArgs var4);

    public Long remove(@NonNull K var1, M ... var2);

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull K key, @NonNull Circle within) {
        return this.search(key, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull K key, @NonNull GeoReference<M> reference, @NonNull Distance radius) {
        return this.search(key, reference, radius, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull K key, @NonNull GeoReference<M> reference, @NonNull Distance radius,  @NonNull RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(key, reference, GeoShape.byRadius(radius), args);
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull K key, @NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox) {
        return this.search(key, reference, boundingBox, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull K key, @NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox,  @NonNull RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(key, reference, GeoShape.byBox(boundingBox), args);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<M>> search(@NonNull K var1, @NonNull GeoReference<M> var2, @NonNull GeoShape var3,  @NonNull RedisGeoCommands.GeoSearchCommandArgs var4);

    default public Long searchAndStore(@NonNull K key, @NonNull K destKey, @NonNull Circle within) {
        return this.searchAndStore(key, destKey, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Long searchAndStore(@NonNull K key, @NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull Distance radius) {
        return this.searchAndStore(key, destKey, reference, radius, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Long searchAndStore(@NonNull K key, @NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull Distance radius,  @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(key, destKey, reference, GeoShape.byRadius(radius), args);
    }

    default public Long searchAndStore(@NonNull K key, @NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox) {
        return this.searchAndStore(key, destKey, reference, boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    default public Long searchAndStore(@NonNull K key, @NonNull K destKey, @NonNull GeoReference<M> reference, @NonNull BoundingBox boundingBox,  @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(key, destKey, reference, GeoShape.byBox(boundingBox), args);
    }

    public Long searchAndStore(@NonNull K var1, @NonNull K var2, @NonNull GeoReference<M> var3, @NonNull GeoShape var4,  @NonNull RedisGeoCommands.GeoSearchStoreCommandArgs var5);

    public @NonNull RedisOperations<K, ?> getOperations();
}

