/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.util.Assert;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.commands.ListBinaryCommands;
import redis.clients.jedis.commands.ListPipelineBinaryCommands;
import redis.clients.jedis.params.LPosParams;

@NullUnmarked
class JedisListCommands
implements RedisListCommands {
    private final JedisConnection connection;

    JedisListCommands(@NonNull JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Long rPush(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpush, ListPipelineBinaryCommands::rpush, key, values);
    }

    @Override
    public List<Long> lPos(byte @NonNull [] key, byte @NonNull [] element, @Nullable Integer rank, @Nullable Integer count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)element, (String)"Element must not be null");
        LPosParams params = new LPosParams();
        if (rank != null) {
            params.rank(rank.intValue());
        }
        if (count != null) {
            return this.connection.invoke().just(ListBinaryCommands::lpos, ListPipelineBinaryCommands::lpos, key, element, params, count);
        }
        return this.connection.invoke().from(ListBinaryCommands::lpos, ListPipelineBinaryCommands::lpos, key, element, params).getOrElse(Collections::singletonList, Collections::emptyList);
    }

    @Override
    public Long lPush(byte @NonNull [] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)values, (String)"Values must not be null");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements");
        return this.connection.invoke().just(ListBinaryCommands::lpush, ListPipelineBinaryCommands::lpush, key, values);
    }

    @Override
    public Long rPushX(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.rpushx(x$0, (byte[][])new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.rpushx((byte[])x$0, new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lPushX(byte @NonNull [] key, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just((rec$, x$0, xva$1) -> rec$.lpushx(x$0, (byte[][])new byte[][]{xva$1}), (rec$, x$0, xva$1) -> rec$.lpushx((byte[])x$0, new byte[][]{xva$1}), key, value);
    }

    @Override
    public Long lLen(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::llen, ListPipelineBinaryCommands::llen, key);
    }

    @Override
    public List<byte @NonNull []> lRange(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lrange, ListPipelineBinaryCommands::lrange, key, start, end);
    }

    @Override
    public void lTrim(byte @NonNull [] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        this.connection.invokeStatus().just(ListBinaryCommands::ltrim, ListPipelineBinaryCommands::ltrim, key, start, end);
    }

    @Override
    public byte[] lIndex(byte @NonNull [] key, long index) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lindex, ListPipelineBinaryCommands::lindex, key, index);
    }

    @Override
    public Long lInsert(byte @NonNull [] key, @NonNull RedisListCommands.Position where, byte @NonNull [] pivot, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::linsert, ListPipelineBinaryCommands::linsert, key, JedisConverters.toListPosition(where), pivot, value);
    }

    @Override
    public byte[] lMove(byte @NonNull [] sourceKey, byte @NonNull [] destinationKey, @NonNull RedisListCommands.Direction from, @NonNull RedisListCommands.Direction to) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)((Object)from), (String)"From direction must not be null");
        Assert.notNull((Object)((Object)to), (String)"To direction must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lmove, ListPipelineBinaryCommands::lmove, sourceKey, destinationKey, ListDirection.valueOf((String)from.name()), ListDirection.valueOf((String)to.name()));
    }

    @Override
    public byte[] bLMove(byte @NonNull [] sourceKey, byte @NonNull [] destinationKey, @NonNull RedisListCommands.Direction from, @NonNull RedisListCommands.Direction to, double timeout) {
        Assert.notNull((Object)sourceKey, (String)"Source key must not be null");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)((Object)from), (String)"From direction must not be null");
        Assert.notNull((Object)((Object)to), (String)"To direction must not be null");
        return this.connection.invoke().just(ListBinaryCommands::blmove, ListPipelineBinaryCommands::blmove, sourceKey, destinationKey, ListDirection.valueOf((String)from.name()), ListDirection.valueOf((String)to.name()), timeout);
    }

    @Override
    public void lSet(byte @NonNull [] key, long index, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.invokeStatus().just(ListBinaryCommands::lset, ListPipelineBinaryCommands::lset, key, index, value);
    }

    @Override
    public Long lRem(byte @NonNull [] key, long count, byte @NonNull [] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lrem, ListPipelineBinaryCommands::lrem, key, count, value);
    }

    @Override
    public byte[] lPop(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lpop, ListPipelineBinaryCommands::lpop, key);
    }

    @Override
    public List<byte[]> lPop(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::lpop, ListPipelineBinaryCommands::lpop, key, (int)count);
    }

    @Override
    public byte[] rPop(byte @NonNull [] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpop, ListPipelineBinaryCommands::rpop, key);
    }

    @Override
    public List<byte @NonNull []> rPop(byte @NonNull [] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpop, ListPipelineBinaryCommands::rpop, key, (int)count);
    }

    @Override
    public List<byte @NonNull []> bLPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(j -> j.blpop(timeout, keys), j -> j.blpop(timeout, keys));
    }

    @Override
    public List<byte @NonNull []> bRPop(int timeout, byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Key must not be null");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements");
        return this.connection.invoke().just(j -> j.brpop(timeout, keys), j -> j.brpop(timeout, keys));
    }

    @Override
    public byte[] rPopLPush(byte @NonNull [] srcKey, byte @NonNull [] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::rpoplpush, ListPipelineBinaryCommands::rpoplpush, srcKey, dstKey);
    }

    @Override
    public byte[] bRPopLPush(int timeout, byte @NonNull [] srcKey, byte @NonNull [] dstKey) {
        Assert.notNull((Object)srcKey, (String)"Source key must not be null");
        Assert.notNull((Object)dstKey, (String)"Destination key must not be null");
        return this.connection.invoke().just(ListBinaryCommands::brpoplpush, ListPipelineBinaryCommands::brpoplpush, srcKey, dstKey, timeout);
    }
}

