/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ExpireArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanStream;
import io.lettuce.core.api.reactive.RedisHashReactiveCommands;
import io.lettuce.core.protocol.CommandArgs;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.ReactiveHashCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveHashCommands
implements ReactiveHashCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveHashCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>> hSet(Publisher<ReactiveHashCommands.HSetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Mono result;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFieldValueMap(), (String)"FieldValueMap must not be null");
            if (command.getFieldValueMap().size() == 1) {
                Map.Entry<ByteBuffer, ByteBuffer> entry = command.getFieldValueMap().entrySet().iterator().next();
                result = command.isUpsert() ? cmd.hset((Object)command.getKey(), (Object)entry.getKey(), (Object)entry.getValue()) : cmd.hsetnx((Object)command.getKey(), (Object)entry.getKey(), (Object)entry.getValue());
            } else {
                Map<ByteBuffer, ByteBuffer> entries = command.getFieldValueMap();
                result = cmd.hmset((Object)command.getKey(), entries).map(Converters::stringToBoolean);
            }
            return result.map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HSetCommand>((ReactiveHashCommands.HSetCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveHashCommands.HGetCommand, ByteBuffer>> hMGet(Publisher<ReactiveHashCommands.HGetCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Mono result;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFields(), (String)"Fields must not be null");
            if (command.getFields().size() == 1) {
                ByteBuffer key = command.getFields().iterator().next();
                result = cmd.hget((Object)command.getKey(), (Object)key.duplicate()).map(value -> KeyValue.fromNullable((Object)key, (Object)value)).defaultIfEmpty((Object)KeyValue.empty((Object)key)).map(Collections::singletonList);
            } else {
                result = cmd.hmget((Object)command.getKey(), (Object[])((ByteBuffer[])command.getFields().toArray(ByteBuffer[]::new))).collectList();
            }
            return result.map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveHashCommands.HGetCommand)command, value.stream().map(keyValue -> (ByteBuffer)keyValue.getValueOrElse(null)).collect(Collectors.toList())));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>> hExists(Publisher<ReactiveHashCommands.HExistsCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getName(), (String)"Name must not be null");
            return cmd.hexists((Object)command.getKey(), (Object)command.getField()).map(value -> new ReactiveRedisConnection.BooleanResponse<ReactiveHashCommands.HExistsCommand>((ReactiveHashCommands.HExistsCommand)command, (Boolean)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>> hDel(Publisher<ReactiveHashCommands.HDelCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFields(), (String)"Fields must not be null");
            return cmd.hdel((Object)command.getKey(), (Object[])((ByteBuffer[])command.getFields().toArray(ByteBuffer[]::new))).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HDelCommand, Long>((ReactiveHashCommands.HDelCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> hLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Command.getKey() must not be null");
            return cmd.hlen((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<ByteBuffer>>> hRandField(Publisher<ReactiveHashCommands.HRandFieldCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Command.getKey() must not be null");
            return new ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux>((ReactiveHashCommands.HRandFieldCommand)command, cmd.hrandfield((Object)command.getKey(), command.getCount()));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hRandFieldWithValues(Publisher<ReactiveHashCommands.HRandFieldCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Command.getKey() must not be null");
            Flux flux = cmd.hrandfieldWithvalues((Object)command.getKey(), command.getCount()).handle((it, sink) -> {
                if (it.isEmpty()) {
                    return;
                }
                sink.next(Converters.entryOf((ByteBuffer)it.getKey(), (ByteBuffer)it.getValue()));
            });
            return new ReactiveRedisConnection.CommandResponse<ReactiveHashCommands.HRandFieldCommand, Flux>((ReactiveHashCommands.HRandFieldCommand)command, flux);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hKeys(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Flux result = cmd.hkeys((Object)command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux>((ReactiveRedisConnection.KeyCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<ByteBuffer>>> hVals(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Flux result = cmd.hvals((Object)command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux>((ReactiveRedisConnection.KeyCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hGetAll(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Flux result = cmd.hgetall((Object)command.getKey());
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux>((ReactiveRedisConnection.KeyCommand)command, result.map(LettuceReactiveHashCommands::toEntry)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Map.Entry<ByteBuffer, ByteBuffer>>>> hScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null");
            Flux result = ScanStream.hscan((RedisHashReactiveCommands)cmd, (Object)command.getKey(), (ScanArgs)LettuceConverters.toScanArgs(command.getOptions()));
            Flux entryFlux = result.map(it -> new Map.Entry<ByteBuffer, ByteBuffer>(){
                final /* synthetic */ LettuceReactiveHashCommands this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ByteBuffer getKey() {
                    return (ByteBuffer)it.getKey();
                }

                @Override
                public ByteBuffer getValue() {
                    return (ByteBuffer)it.getValue();
                }

                @Override
                public ByteBuffer setValue(ByteBuffer value) {
                    throw new UnsupportedOperationException("Cannot set value for entry in cursor.");
                }
            });
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux>((ReactiveRedisConnection.KeyScanCommand)command, entryFlux));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>> hStrLen(Publisher<ReactiveHashCommands.HStrLenCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getField(), (String)"Field must not be null");
            return cmd.hstrlen((Object)command.getKey(), (Object)command.getField()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HStrLenCommand, Long>((ReactiveHashCommands.HStrLenCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashExpireCommand, Long>> applyHashFieldExpiration(Publisher<ReactiveHashCommands.HashExpireCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFields(), (String)"Fields must not be null");
            Object[] fields = (ByteBuffer[])command.getFields().toArray(ByteBuffer[]::new);
            if (command.getExpiration().isPersistent()) {
                return cmd.hpersist((Object)command.getKey(), fields).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashExpireCommand, Long>((ReactiveHashCommands.HashExpireCommand)command, (Long)value));
            }
            ExpireArgs args = new ExpireArgs(this, (ReactiveHashCommands.HashExpireCommand)command){
                final /* synthetic */ ReactiveHashCommands.HashExpireCommand val$command;
                final /* synthetic */ LettuceReactiveHashCommands this$0;
                {
                    this.val$command = hashExpireCommand;
                    this.this$0 = this$0;
                }

                public <K, V> void build(CommandArgs<K, V> args) {
                    super.build(args);
                    if (ObjectUtils.nullSafeEquals((Object)this.val$command.getOptions(), (Object)ExpirationOptions.none())) {
                        return;
                    }
                    args.add(this.val$command.getOptions().getCondition().name());
                }
            };
            if (command.getExpiration().isUnixTimestamp()) {
                if (command.getExpiration().getTimeUnit().equals((Object)TimeUnit.MILLISECONDS)) {
                    return cmd.hpexpireat((Object)command.getKey(), command.getExpiration().getExpirationTimeInMilliseconds(), args, fields).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashExpireCommand, Long>((ReactiveHashCommands.HashExpireCommand)command, (Long)value));
                }
                return cmd.hexpireat((Object)command.getKey(), command.getExpiration().getExpirationTimeInSeconds(), args, fields).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashExpireCommand, Long>((ReactiveHashCommands.HashExpireCommand)command, (Long)value));
            }
            if (command.getExpiration().getTimeUnit().equals((Object)TimeUnit.MILLISECONDS)) {
                return cmd.hpexpire((Object)command.getKey(), command.getExpiration().getExpirationTimeInMilliseconds(), args, fields).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashExpireCommand, Long>((ReactiveHashCommands.HashExpireCommand)command, (Long)value));
            }
            return cmd.hexpire((Object)command.getKey(), command.getExpiration().getExpirationTimeInSeconds(), args, fields).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashExpireCommand, Long>((ReactiveHashCommands.HashExpireCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashFieldsCommand, Long>> hPersist(Publisher<ReactiveHashCommands.HashFieldsCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFields(), (String)"Fields must not be null");
            return cmd.hpersist((Object)command.getKey(), (Object[])((ByteBuffer[])command.getFields().toArray(ByteBuffer[]::new))).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashFieldsCommand, Long>((ReactiveHashCommands.HashFieldsCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashFieldsCommand, Long>> hTtl(Publisher<ReactiveHashCommands.HashFieldsCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFields(), (String)"Fields must not be null");
            return cmd.httl((Object)command.getKey(), (Object[])((ByteBuffer[])command.getFields().toArray(ByteBuffer[]::new))).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashFieldsCommand, Long>((ReactiveHashCommands.HashFieldsCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashFieldsCommand, Long>> hpTtl(Publisher<ReactiveHashCommands.HashFieldsCommand> commands) {
        return this.connection.execute(cmd -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getFields(), (String)"Fields must not be null");
            return cmd.hpttl((Object)command.getKey(), (Object[])((ByteBuffer[])command.getFields().toArray(ByteBuffer[]::new))).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveHashCommands.HashFieldsCommand, Long>((ReactiveHashCommands.HashFieldsCommand)command, (Long)value));
        }));
    }

    private static Map.Entry<ByteBuffer, ByteBuffer> toEntry(final KeyValue<ByteBuffer, ByteBuffer> kv) {
        return new Map.Entry<ByteBuffer, ByteBuffer>(){

            @Override
            public ByteBuffer getKey() {
                return (ByteBuffer)kv.getKey();
            }

            @Override
            public ByteBuffer getValue() {
                return (ByteBuffer)kv.getValue();
            }

            @Override
            public ByteBuffer setValue(ByteBuffer value) {
                throw new UnsupportedOperationException("Cannot set value for entry");
            }
        };
    }
}

