/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisClusterServerCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;

@NullUnmarked
class JedisClusterServerCommands
implements RedisClusterServerCommands {
    private final JedisClusterConnection connection;

    JedisClusterServerCommands(@NonNull JedisClusterConnection connection) {
        this.connection = connection;
    }

    @Override
    public void bgReWriteAof(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::bgrewriteaof, node);
    }

    @Override
    public void bgReWriteAof() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(Jedis::bgrewriteaof);
    }

    @Override
    public void bgSave() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(Jedis::bgsave);
    }

    @Override
    public void bgSave(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::bgsave, node);
    }

    @Override
    public Long lastSave() {
        ArrayList result = new ArrayList(this.executeCommandOnAllNodes(Jedis::lastsave).resultsAsList());
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        Collections.sort(result, Collections.reverseOrder());
        return (Long)result.get(0);
    }

    @Override
    public Long lastSave(@NonNull RedisClusterNode node) {
        return (Long)this.executeCommandOnSingleNode(Jedis::lastsave, node).getValue();
    }

    @Override
    public void save() {
        this.executeCommandOnAllNodes(Jedis::save);
    }

    @Override
    public void save(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::save, node);
    }

    @Override
    public Long dbSize() {
        List dbSizes = this.executeCommandOnAllNodes(Jedis::dbSize).resultsAsList();
        if (CollectionUtils.isEmpty(dbSizes)) {
            return 0L;
        }
        Long size = 0L;
        for (Long value : dbSizes) {
            size = size + value;
        }
        return size;
    }

    @Override
    public Long dbSize(@NonNull RedisClusterNode node) {
        return (Long)this.executeCommandOnSingleNode(Jedis::dbSize, node).getValue();
    }

    @Override
    public void flushDb() {
        this.executeCommandOnAllNodes(Jedis::flushDB);
    }

    @Override
    public void flushDb( @NonNull RedisServerCommands.FlushOption option) {
        this.executeCommandOnAllNodes(it -> it.flushDB(JedisConverters.toFlushMode(option)));
    }

    @Override
    public void flushDb(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::flushDB, node);
    }

    @Override
    public void flushDb(@NonNull RedisClusterNode node,  @NonNull RedisServerCommands.FlushOption option) {
        this.executeCommandOnSingleNode(it -> it.flushDB(JedisConverters.toFlushMode(option)), node);
    }

    @Override
    public void flushAll() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(Jedis::flushAll);
    }

    @Override
    public void flushAll( @NonNull RedisServerCommands.FlushOption option) {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S it) -> it.flushAll(JedisConverters.toFlushMode(option)));
    }

    @Override
    public void flushAll(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::flushAll, node);
    }

    @Override
    public void flushAll(@NonNull RedisClusterNode node,  @NonNull RedisServerCommands.FlushOption option) {
        this.executeCommandOnSingleNode(it -> it.flushAll(JedisConverters.toFlushMode(option)), node);
    }

    @Override
    public Properties info() {
        Properties infos = new Properties();
        List nodeResults = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> JedisConverters.toProperties(client.info())).getResults();
        for (ClusterCommandExecutor.NodeResult nodeProperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : ((Properties)nodeProperties.getValue()).entrySet()) {
                infos.put(nodeProperties.getNode().asString() + "." + String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(@NonNull RedisClusterNode node) {
        return JedisConverters.toProperties((String)this.executeCommandOnSingleNode(Jedis::info, node).getValue());
    }

    @Override
    public Properties info(@NonNull String section) {
        Assert.notNull((Object)section, (String)"Section must not be null");
        Properties infos = new Properties();
        List nodeResults = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> JedisConverters.toProperties(client.info(section))).getResults();
        for (ClusterCommandExecutor.NodeResult nodeProperties : nodeResults) {
            for (Map.Entry<Object, Object> entry : ((Properties)nodeProperties.getValue()).entrySet()) {
                infos.put(nodeProperties.getNode().asString() + "." + String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return infos;
    }

    @Override
    public Properties info(@NonNull RedisClusterNode node, @NonNull String section) {
        Assert.notNull((Object)section, (String)"Section must not be null");
        return JedisConverters.toProperties((String)this.executeCommandOnSingleNode(client -> client.info(section), node).getValue());
    }

    @Override
    public void shutdown() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S jedis) -> {
            jedis.shutdown();
            return null;
        });
    }

    @Override
    public void shutdown(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(jedis -> {
            jedis.shutdown();
            return null;
        }, node);
    }

    @Override
    public void shutdown( @NonNull RedisServerCommands.ShutdownOption option) {
        if (option == null) {
            this.shutdown();
            return;
        }
        throw new IllegalArgumentException("Shutdown with options is not supported for jedis");
    }

    @Override
    public Properties getConfig(@NonNull String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        JedisClusterConnection.JedisClusterCommandCallback command = jedis -> jedis.configGet(pattern);
        List nodeResults = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(command).getResults();
        Properties nodesConfiguration = new Properties();
        for (ClusterCommandExecutor.NodeResult nodeResult : nodeResults) {
            String prefix = nodeResult.getNode().asString();
            for (Map.Entry entry : ((Map)nodeResult.getValue()).entrySet()) {
                String newKey = prefix.concat(".").concat((String)entry.getKey());
                String value = (String)entry.getValue();
                nodesConfiguration.setProperty(newKey, value);
            }
        }
        return nodesConfiguration;
    }

    @Override
    public Properties getConfig(@NonNull RedisClusterNode node, @NonNull String pattern) {
        Assert.notNull((Object)pattern, (String)"Pattern must not be null");
        return (Properties)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode((S client) -> Converters.toProperties(client.configGet(pattern)), node).getValue();
    }

    @Override
    public void setConfig(@NonNull String param, @NonNull String value) {
        Assert.notNull((Object)param, (String)"Parameter must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes((S client) -> client.configSet(param, value));
    }

    @Override
    public void setConfig(@NonNull RedisClusterNode node, @NonNull String param, @NonNull String value) {
        Assert.notNull((Object)param, (String)"Parameter must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        this.executeCommandOnSingleNode(client -> client.configSet(param, value), node);
    }

    @Override
    public void resetConfigStats() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(Jedis::configResetStat);
    }

    @Override
    public void rewriteConfig() {
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(Jedis::configRewrite);
    }

    @Override
    public void resetConfigStats(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::configResetStat, node);
    }

    @Override
    public void rewriteConfig(@NonNull RedisClusterNode node) {
        this.executeCommandOnSingleNode(Jedis::configRewrite, node);
    }

    @Override
    public Long time(@NonNull TimeUnit timeUnit) {
        return this.convertListOfStringToTime((List)this.connection.getClusterCommandExecutor().executeCommandOnArbitraryNode(Jedis::time).getValue(), timeUnit);
    }

    @Override
    public Long time(@NonNull RedisClusterNode node, @NonNull TimeUnit timeUnit) {
        return this.convertListOfStringToTime((List)this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(Jedis::time, node).getValue(), timeUnit);
    }

    @Override
    public void killClient(@NonNull String host, int port) {
        Assert.hasText((String)host, (String)"Host for 'CLIENT KILL' must not be 'null' or 'empty'");
        String hostAndPort = "%s:%d".formatted(host, port);
        JedisClusterConnection.JedisClusterCommandCallback command = client -> client.clientKill(hostAndPort);
        this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(command);
    }

    @Override
    public void setClientName(byte @NonNull [] name) {
        throw new InvalidDataAccessApiUsageException("CLIENT SETNAME is not supported in cluster environment");
    }

    @Override
    public String getClientName() {
        throw new InvalidDataAccessApiUsageException("CLIENT GETNAME is not supported in cluster environment");
    }

    @Override
    public List<@NonNull RedisClientInfo> getClientList() {
        List map = this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(Jedis::clientList).resultsAsList();
        ArrayList<RedisClientInfo> result = new ArrayList<RedisClientInfo>();
        for (String infos : map) {
            result.addAll(JedisConverters.toListOfRedisClientInformation(infos));
        }
        return result;
    }

    @Override
    public List<@NonNull RedisClientInfo> getClientList(@NonNull RedisClusterNode node) {
        return JedisConverters.toListOfRedisClientInformation((String)this.executeCommandOnSingleNode(Jedis::clientList, node).getValue());
    }

    @Override
    public void replicaOf(@NonNull String host, int port) {
        throw new InvalidDataAccessApiUsageException("REPLICAOF is not supported in cluster environment; Please use CLUSTER REPLICATE");
    }

    @Override
    public void replicaOfNoOne() {
        throw new InvalidDataAccessApiUsageException("REPLICAOF is not supported in cluster environment; Please use CLUSTER REPLICATE");
    }

    @Override
    public void migrate(byte @NonNull [] key, @NonNull RedisNode target, int dbIndex,  @Nullable RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    @Override
    public void migrate(byte @NonNull [] key, @NonNull RedisNode target, int dbIndex,  @Nullable RedisServerCommands.MigrateOption option, long timeout) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)target, (String)"Target node must not be null");
        int timeoutToUse = timeout <= Integer.MAX_VALUE ? (int)timeout : Integer.MAX_VALUE;
        RedisClusterNode node = this.connection.getTopologyProvider().getTopology().lookup(target.getRequiredHost(), target.getRequiredPort());
        this.executeCommandOnSingleNode(client -> client.migrate(target.getRequiredHost(), target.getRequiredPort(), key, dbIndex, timeoutToUse), node);
    }

    private Long convertListOfStringToTime(List<@NonNull String> serverTimeInformation, TimeUnit timeUnit) {
        Assert.notEmpty(serverTimeInformation, (String)"Received invalid result from server; Expected 2 items in collection");
        Assert.isTrue((serverTimeInformation.size() == 2 ? 1 : 0) != 0, (String)("Received invalid number of arguments from redis server; Expected 2 received " + serverTimeInformation.size()));
        return Converters.toTimeMillis(serverTimeInformation.get(0), serverTimeInformation.get(1), timeUnit);
    }

    private <T> ClusterCommandExecutor.NodeResult<T> executeCommandOnSingleNode(@NonNull JedisClusterConnection.JedisClusterCommandCallback<T> cmd, @NonNull RedisClusterNode node) {
        return this.connection.getClusterCommandExecutor().executeCommandOnSingleNode(cmd, node);
    }

    private <T> ClusterCommandExecutor.MultiNodeResult<T> executeCommandOnAllNodes(@NonNull JedisClusterConnection.JedisClusterCommandCallback<T> cmd) {
        return this.connection.getClusterCommandExecutor().executeCommandOnAllNodes(cmd);
    }
}

