/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.args.ExpiryOption;
import redis.clients.jedis.commands.HashPipelineBinaryCommands;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;

class JedisHashCommands
implements RedisHashCommands {
    private final JedisConnection connection;

    JedisHashCommands(JedisConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::hset, HashPipelineBinaryCommands::hset, key, field, value).get(JedisConverters.longToBoolean());
    }

    @Override
    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        return this.connection.invoke().from(Jedis::hsetnx, HashPipelineBinaryCommands::hsetnx, key, field, value).get(JedisConverters.longToBoolean());
    }

    @Override
    public Long hDel(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().just(Jedis::hdel, HashPipelineBinaryCommands::hdel, key, fields);
    }

    @Override
    public Boolean hExists(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Fields must not be null");
        return this.connection.invoke().just(Jedis::hexists, HashPipelineBinaryCommands::hexists, key, field);
    }

    @Override
    public byte[] hGet(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hget, HashPipelineBinaryCommands::hget, key, field);
    }

    @Override
    public Map<byte[], byte[]> hGetAll(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hgetAll, HashPipelineBinaryCommands::hgetAll, key);
    }

    @Override
    @Nullable
    public byte[] hRandField(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hrandfield, HashPipelineBinaryCommands::hrandfield, key);
    }

    @Override
    @Nullable
    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (Map.Entry)this.connection.invoke().from(Jedis::hrandfieldWithValues, HashPipelineBinaryCommands::hrandfieldWithValues, key, 1L).get(mapEntryList -> mapEntryList.isEmpty() ? null : (Map.Entry)mapEntryList.get(0));
    }

    @Override
    @Nullable
    public List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hrandfield, HashPipelineBinaryCommands::hrandfield, key, count);
    }

    @Override
    @Nullable
    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return (List)this.connection.invoke().from(Jedis::hrandfieldWithValues, HashPipelineBinaryCommands::hrandfieldWithValues, key, count).get(mapEntryList -> {
            ArrayList convertedMapEntryList = new ArrayList(mapEntryList.size());
            mapEntryList.forEach(entry -> convertedMapEntryList.add(Converters.entryOf((byte[])entry.getKey(), (byte[])entry.getValue())));
            return convertedMapEntryList;
        });
    }

    @Override
    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hincrBy, HashPipelineBinaryCommands::hincrBy, key, field, delta);
    }

    @Override
    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hincrByFloat, HashPipelineBinaryCommands::hincrByFloat, key, field, delta);
    }

    @Override
    public Set<byte[]> hKeys(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hkeys, HashPipelineBinaryCommands::hkeys, key);
    }

    @Override
    public Long hLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hlen, HashPipelineBinaryCommands::hlen, key);
    }

    @Override
    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)fields, (String)"Fields must not be null");
        return this.connection.invoke().just(Jedis::hmget, HashPipelineBinaryCommands::hmget, key, fields);
    }

    @Override
    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull(hashes, (String)"Hashes must not be null");
        this.connection.invokeStatus().just(Jedis::hmset, HashPipelineBinaryCommands::hmset, key, hashes);
    }

    @Override
    public List<byte[]> hVals(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.connection.invoke().just(Jedis::hvals, HashPipelineBinaryCommands::hvals, key);
    }

    @Override
    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return this.hScan(key, Cursor.CursorId.initial(), options);
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, cursorId, options){

            @Override
            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (JedisHashCommands.this.isQueueing() || JedisHashCommands.this.isPipelined()) {
                    throw new InvalidDataAccessApiUsageException("'HSCAN' cannot be called in pipeline / transaction mode");
                }
                ScanParams params = JedisConverters.toScanParams(options);
                ScanResult result = JedisHashCommands.this.connection.getJedis().hscan(key, JedisConverters.toBytes(cursorId), params);
                return new ScanIteration<Map.Entry<byte[], byte[]>>(Cursor.CursorId.of(result.getCursor()), result.getResult());
            }

            @Override
            protected void doClose() {
                JedisHashCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public List<Long> hExpire(byte[] key, long seconds, ExpirationOptions.Condition condition, byte[] ... fields) {
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().just(Jedis::hexpire, HashPipelineBinaryCommands::hexpire, key, seconds, fields);
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().just(Jedis::hexpire, HashPipelineBinaryCommands::hexpire, key, seconds, option, fields);
    }

    @Override
    public List<Long> hpExpire(byte[] key, long millis, ExpirationOptions.Condition condition, byte[] ... fields) {
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().just(Jedis::hpexpire, HashPipelineBinaryCommands::hpexpire, key, millis, fields);
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().just(Jedis::hpexpire, HashPipelineBinaryCommands::hpexpire, key, millis, option, fields);
    }

    @Override
    public List<Long> hExpireAt(byte[] key, long unixTime, ExpirationOptions.Condition condition, byte[] ... fields) {
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().just(Jedis::hexpireAt, HashPipelineBinaryCommands::hexpireAt, key, unixTime, fields);
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().just(Jedis::hexpireAt, HashPipelineBinaryCommands::hexpireAt, key, unixTime, option, fields);
    }

    @Override
    public List<Long> hpExpireAt(byte[] key, long unixTimeInMillis, ExpirationOptions.Condition condition, byte[] ... fields) {
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return this.connection.invoke().just(Jedis::hpexpireAt, HashPipelineBinaryCommands::hpexpireAt, key, unixTimeInMillis, fields);
        }
        ExpiryOption option = ExpiryOption.valueOf((String)condition.name());
        return this.connection.invoke().just(Jedis::hpexpireAt, HashPipelineBinaryCommands::hpexpireAt, key, unixTimeInMillis, fields);
    }

    @Override
    public List<Long> hPersist(byte[] key, byte[] ... fields) {
        return this.connection.invoke().just(Jedis::hpersist, HashPipelineBinaryCommands::hpersist, key, fields);
    }

    @Override
    public List<Long> hTtl(byte[] key, byte[] ... fields) {
        return this.connection.invoke().just(Jedis::httl, HashPipelineBinaryCommands::httl, key, fields);
    }

    @Override
    public List<Long> hTtl(byte[] key, TimeUnit timeUnit, byte[] ... fields) {
        return this.connection.invoke().fromMany(Jedis::httl, HashPipelineBinaryCommands::httl, key, fields).toList(Converters.secondsToTimeUnit(timeUnit));
    }

    @Override
    public List<Long> hpTtl(byte[] key, byte[] ... fields) {
        return this.connection.invoke().just(Jedis::hpttl, HashPipelineBinaryCommands::hpttl, key, fields);
    }

    @Override
    @Nullable
    public Long hStrLen(byte[] key, byte[] field) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)field, (String)"Field must not be null");
        return this.connection.invoke().just(Jedis::hstrlen, HashPipelineBinaryCommands::hstrlen, key, field);
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }
}

