/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanStream;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.Value;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZAggregateArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.reactive.RedisSortedSetReactiveCommands;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.DefaultTuple;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class LettuceReactiveZSetCommands
implements ReactiveZSetCommands {
    private final LettuceReactiveRedisConnection connection;

    LettuceReactiveZSetCommands(LettuceReactiveRedisConnection connection) {
        Assert.notNull((Object)connection, (String)"Connection must not be null");
        this.connection = connection;
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Number>> zAdd(Publisher<ReactiveZSetCommands.ZAddCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notEmpty(command.getTuples(), (String)"Tuples must not be empty or null");
            ZAddArgs args = null;
            if (command.isIncr()) {
                if (command.getTuples().size() > 1) {
                    throw new IllegalArgumentException("ZADD INCR must not contain more than one tuple");
                }
                Tuple tuple2 = command.getTuples().iterator().next();
                return reactiveCommands.zaddincr((Object)command.getKey(), tuple2.getScore().doubleValue(), (Object)ByteBuffer.wrap(tuple2.getValue())).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Double>((ReactiveZSetCommands.ZAddCommand)command, (Double)value));
            }
            if (command.isReturnTotalChanged()) {
                args = ZAddArgs.Builder.ch();
            }
            if (command.isIfNotExists()) {
                args = args == null ? ZAddArgs.Builder.nx() : args.nx();
            } else if (command.isIfExists()) {
                ZAddArgs zAddArgs = args = args == null ? ZAddArgs.Builder.xx() : args.xx();
            }
            if (command.isGt()) {
                args = args == null ? ZAddArgs.Builder.gt() : args.gt();
            } else if (command.isLt()) {
                args = args == null ? ZAddArgs.Builder.lt() : args.lt();
            }
            ScoredValue[] values = (ScoredValue[])command.getTuples().stream().map(tuple -> ScoredValue.fromNullable((double)tuple.getScore(), (Object)ByteBuffer.wrap(tuple.getValue()))).toArray(ScoredValue[]::new);
            Mono result = args == null ? reactiveCommands.zadd((Object)command.getKey(), values) : reactiveCommands.zadd((Object)command.getKey(), args, values);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAddCommand, Long>((ReactiveZSetCommands.ZAddCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>> zRem(Publisher<ReactiveZSetCommands.ZRemCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notEmpty(command.getValues(), (String)"Values must not be null or empty");
            Object[] values = (ByteBuffer[])command.getValues().toArray(ByteBuffer[]::new);
            return reactiveCommands.zrem((Object)command.getKey(), values).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemCommand, Long>((ReactiveZSetCommands.ZRemCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>> zIncrBy(Publisher<ReactiveZSetCommands.ZIncrByCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getValue(), (String)"Member must not be null");
            Assert.notNull((Object)command.getIncrement(), (String)"Increment value must not be null");
            return reactiveCommands.zincrby((Object)command.getKey(), command.getIncrement().doubleValue(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZIncrByCommand, Double>((ReactiveZSetCommands.ZIncrByCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<ByteBuffer>>> zRandMember(Publisher<ReactiveZSetCommands.ZRandMemberCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux>((ReactiveZSetCommands.ZRandMemberCommand)command, reactiveCommands.zrandmember((Object)command.getKey(), command.getCount()));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux<Tuple>>> zRandMemberWithScore(Publisher<ReactiveZSetCommands.ZRandMemberCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Flux result = reactiveCommands.zrandmemberWithScores((Object)command.getKey(), command.getCount());
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRandMemberCommand, Flux>((ReactiveZSetCommands.ZRandMemberCommand)command, result.map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>> zRank(Publisher<ReactiveZSetCommands.ZRankCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null");
            Mono result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? reactiveCommands.zrank((Object)command.getKey(), (Object)command.getValue()) : reactiveCommands.zrevrank((Object)command.getKey(), (Object)command.getValue());
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRankCommand, Long>((ReactiveZSetCommands.ZRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux<Tuple>>> zRange(Publisher<ReactiveZSetCommands.ZRangeCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            long start = LettuceConverters.getLowerBoundIndex(command.getRange());
            long stop = LettuceConverters.getUpperBoundIndex(command.getRange());
            Flux result = ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? (command.isWithScores() ? reactiveCommands.zrangeWithScores((Object)command.getKey(), start, stop).map(this::toTuple) : reactiveCommands.zrange((Object)command.getKey(), start, stop).map(value -> this.toTuple((ByteBuffer)value, Double.NaN))) : (command.isWithScores() ? reactiveCommands.zrevrangeWithScores((Object)command.getKey(), start, stop).map(this::toTuple) : reactiveCommands.zrevrange((Object)command.getKey(), start, stop).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeCommand, Flux>((ReactiveZSetCommands.ZRangeCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeStoreCommand, Mono<Long>>> zRangeStore(Publisher<ReactiveZSetCommands.ZRangeStoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Mono result;
            block9: {
                Limit limit;
                block8: {
                    Assert.notNull((Object)command.getKey(), (String)"Source key must not be null");
                    Assert.notNull((Object)command.getDestKey(), (String)"Destination key must not be null");
                    Assert.notNull(command.getRange(), (String)"Range must not be null");
                    Assert.notNull((Object)command.getLimit(), (String)"Limit must not be null");
                    limit = LettuceConverters.toLimit(command.getLimit());
                    if (command.getDirection() != Sort.Direction.ASC) break block8;
                    switch (command.getRangeMode()) {
                        case ByScore: {
                            result = reactiveCommands.zrangestorebyscore((Object)command.getDestKey(), (Object)command.getKey(), LettuceConverters.toRange(command.getRange()), limit);
                            break block9;
                        }
                        case ByLex: {
                            result = reactiveCommands.zrangestorebylex((Object)command.getDestKey(), (Object)command.getKey(), RangeConverter.toRange(command.getRange()), limit);
                            break block9;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported value: " + command.getRangeMode());
                        }
                    }
                }
                switch (command.getRangeMode()) {
                    case ByScore: {
                        result = reactiveCommands.zrevrangestorebyscore((Object)command.getDestKey(), (Object)command.getKey(), LettuceConverters.toRange(command.getRange()), limit);
                        break;
                    }
                    case ByLex: {
                        result = reactiveCommands.zrevrangestorebylex((Object)command.getDestKey(), (Object)command.getKey(), RangeConverter.toRange(command.getRange()), limit);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported value: " + command.getRangeMode());
                    }
                }
            }
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeStoreCommand, Mono>((ReactiveZSetCommands.ZRangeStoreCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux<Tuple>>> zRangeByScore(Publisher<ReactiveZSetCommands.ZRangeByScoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Flux result;
            boolean isLimited;
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            boolean bl = isLimited = command.getLimit().isPresent() && !command.getLimit().get().isUnlimited();
            if (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC)) {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? reactiveCommands.zrangebyscoreWithScores((Object)command.getKey(), range).map(this::toTuple) : reactiveCommands.zrangebyscoreWithScores((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(this::toTuple)) : (!isLimited ? reactiveCommands.zrangebyscore((Object)command.getKey(), range).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)) : reactiveCommands.zrangebyscore((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)));
            } else {
                Range range = RangeConverter.toRange(command.getRange());
                result = command.isWithScores() ? (!isLimited ? reactiveCommands.zrevrangebyscoreWithScores((Object)command.getKey(), range).map(this::toTuple) : reactiveCommands.zrevrangebyscoreWithScores((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(this::toTuple)) : (!isLimited ? reactiveCommands.zrevrangebyscore((Object)command.getKey(), range).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)) : reactiveCommands.zrevrangebyscore((Object)command.getKey(), range, LettuceConverters.toLimit(command.getLimit().get())).map(value -> this.toTuple((ByteBuffer)value, Double.NaN)));
            }
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByScoreCommand, Flux>((ReactiveZSetCommands.ZRangeByScoreCommand)command, Flux.from((Publisher)result)));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyCommand, Flux<Tuple>>> zScan(Publisher<ReactiveRedisConnection.KeyScanCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getOptions(), (String)"ScanOptions must not be null");
            Flux result = ScanStream.zscan((RedisSortedSetReactiveCommands)reactiveCommands, (Object)command.getKey(), (ScanArgs)LettuceConverters.toScanArgs(command.getOptions())).map(this::toTuple);
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.KeyScanCommand, Flux>((ReactiveRedisConnection.KeyScanCommand)command, result));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>> zCount(Publisher<ReactiveZSetCommands.ZCountCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            Range range = RangeConverter.toRange(command.getRange());
            Mono result = reactiveCommands.zcount((Object)command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZCountCommand, Long>((ReactiveZSetCommands.ZCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>> zLexCount(Publisher<ReactiveZSetCommands.ZLexCountCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            Mono result = reactiveCommands.zlexcount((Object)command.getKey(), RangeConverter.toRange(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZLexCountCommand, Long>((ReactiveZSetCommands.ZLexCountCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZPopCommand, Flux<Tuple>>> zPop(Publisher<ReactiveZSetCommands.ZPopCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Flux result = command.getCount() > 1L ? (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? reactiveCommands.zpopmin((Object)command.getKey(), command.getCount()) : reactiveCommands.zpopmax((Object)command.getKey(), command.getCount())) : (command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? reactiveCommands.zpopmin((Object)command.getKey()) : reactiveCommands.zpopmax((Object)command.getKey())).flux();
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZPopCommand, Flux>((ReactiveZSetCommands.ZPopCommand)command, result.filter(Value::hasValue).map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux<Tuple>>> bZPop(Publisher<ReactiveZSetCommands.BZPopCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getTimeout(), (String)"Timeout must not be null");
            if (command.getTimeUnit() == TimeUnit.MILLISECONDS) {
                double timeout = TimeoutUtils.toDoubleSeconds(command.getTimeout(), command.getTimeUnit());
                Mono commandResult = command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? reactiveCommands.bzpopmin(timeout, (Object[])new ByteBuffer[]{command.getKey()}) : reactiveCommands.bzpopmax(timeout, (Object[])new ByteBuffer[]{command.getKey()});
                Mono result = commandResult.filter(Value::hasValue).map(Value::getValue);
                return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux>((ReactiveZSetCommands.BZPopCommand)command, result.filter(Value::hasValue).map(this::toTuple).flux());
            }
            long timeout = command.getTimeUnit().toSeconds(command.getTimeout());
            Mono commandResult = command.getDirection() == ReactiveZSetCommands.PopDirection.MIN ? reactiveCommands.bzpopmin(timeout, (Object[])new ByteBuffer[]{command.getKey()}) : reactiveCommands.bzpopmax(timeout, (Object[])new ByteBuffer[]{command.getKey()});
            Mono result = commandResult.filter(Value::hasValue).map(Value::getValue);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.BZPopCommand, Flux>((ReactiveZSetCommands.BZPopCommand)command, result.filter(Value::hasValue).map(this::toTuple).flux());
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> zCard(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            return reactiveCommands.zcard((Object)command.getKey()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>> zScore(Publisher<ReactiveZSetCommands.ZScoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull((Object)command.getValue(), (String)"Value must not be null");
            return reactiveCommands.zscore((Object)command.getKey(), (Object)command.getValue()).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZScoreCommand, Double>((ReactiveZSetCommands.ZScoreCommand)command, (Double)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.MultiValueResponse<ReactiveZSetCommands.ZMScoreCommand, Double>> zMScore(Publisher<ReactiveZSetCommands.ZMScoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getValues(), (String)"Values must not be null");
            return reactiveCommands.zmscore((Object)command.getKey(), (Object[])command.getValues().toArray(new ByteBuffer[0])).map(value -> new ReactiveRedisConnection.MultiValueResponse((ReactiveZSetCommands.ZMScoreCommand)command, value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>> zRemRangeByRank(Publisher<ReactiveZSetCommands.ZRemRangeByRankCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            Mono result = reactiveCommands.zremrangebyrank((Object)command.getKey(), LettuceConverters.getLowerBoundIndex(command.getRange()), LettuceConverters.getUpperBoundIndex(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByRankCommand, Long>((ReactiveZSetCommands.ZRemRangeByRankCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>> zRemRangeByScore(Publisher<ReactiveZSetCommands.ZRemRangeByScoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            Range range = RangeConverter.toRange(command.getRange());
            Mono result = reactiveCommands.zremrangebyscore((Object)command.getKey(), range);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByScoreCommand, Long>((ReactiveZSetCommands.ZRemRangeByScoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByLexCommand, Long>> zRemRangeByLex(Publisher<ReactiveZSetCommands.ZRemRangeByLexCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Key must not be null");
            Assert.notNull(command.getRange(), (String)"Range must not be null");
            Mono result = reactiveCommands.zremrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange()));
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZRemRangeByLexCommand, Long>((ReactiveZSetCommands.ZRemRangeByLexCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<ByteBuffer>>> zDiff(Publisher<? extends ReactiveZSetCommands.ZDiffCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notEmpty(command.getKeys(), (String)"Keys must not be null or empty");
            Object[] sourceKeys = command.getKeys().toArray(new ByteBuffer[0]);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux>((ReactiveZSetCommands.ZDiffCommand)command, reactiveCommands.zdiff(sourceKeys));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux<Tuple>>> zDiffWithScores(Publisher<? extends ReactiveZSetCommands.ZDiffCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notEmpty(command.getKeys(), (String)"Keys must not be null or empty");
            Object[] sourceKeys = command.getKeys().toArray(new ByteBuffer[0]);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZDiffCommand, Flux>((ReactiveZSetCommands.ZDiffCommand)command, reactiveCommands.zdiffWithScores(sourceKeys).map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZDiffStoreCommand, Long>> zDiffStore(Publisher<ReactiveZSetCommands.ZDiffStoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            Object[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            return reactiveCommands.zdiffstore((Object)command.getKey(), sourceKeys).map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZDiffStoreCommand, Long>((ReactiveZSetCommands.ZDiffStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<ByteBuffer>>> zInter(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            Flux result = args != null ? reactiveCommands.zinter((ZAggregateArgs)args, sourceKeys) : reactiveCommands.zinter(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux>((ReactiveZSetCommands.ZAggregateCommand)command, result);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<Tuple>>> zInterWithScores(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            Flux result = args != null ? reactiveCommands.zinterWithScores((ZAggregateArgs)args, sourceKeys) : reactiveCommands.zinterWithScores(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux>((ReactiveZSetCommands.ZAggregateCommand)command, result.map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>> zInterStore(Publisher<? extends ReactiveZSetCommands.ZAggregateStoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = command.getSourceKeys().toArray(new ByteBuffer[0]);
            Mono result = args != null ? reactiveCommands.zinterstore((Object)command.getKey(), args, sourceKeys) : reactiveCommands.zinterstore((Object)command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>((ReactiveZSetCommands.ZAggregateStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<ByteBuffer>>> zUnion(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().toArray(ByteBuffer[]::new);
            Flux result = args != null ? reactiveCommands.zunion((ZAggregateArgs)args, sourceKeys) : reactiveCommands.zunion(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux>((ReactiveZSetCommands.ZAggregateCommand)command, result);
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux<Tuple>>> zUnionWithScores(Publisher<? extends ReactiveZSetCommands.ZAggregateCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).map(command -> {
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().toArray(ByteBuffer[]::new);
            Flux result = args != null ? reactiveCommands.zunionWithScores((ZAggregateArgs)args, sourceKeys) : reactiveCommands.zunionWithScores(sourceKeys);
            return new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZAggregateCommand, Flux>((ReactiveZSetCommands.ZAggregateCommand)command, result.map(this::toTuple));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>> zUnionStore(Publisher<? extends ReactiveZSetCommands.ZAggregateStoreCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null");
            Assert.notEmpty(command.getSourceKeys(), (String)"Source keys must not be null or empty");
            ZStoreArgs args = null;
            if (command.getAggregateFunction().isPresent() || !command.getWeights().isEmpty()) {
                args = LettuceReactiveZSetCommands.zStoreArgs(command.getAggregateFunction().isPresent() ? command.getAggregateFunction().get() : null, command.getWeights());
            }
            Object[] sourceKeys = (ByteBuffer[])command.getSourceKeys().toArray(ByteBuffer[]::new);
            Mono result = args != null ? reactiveCommands.zunionstore((Object)command.getKey(), args, sourceKeys) : reactiveCommands.zunionstore((Object)command.getKey(), sourceKeys);
            return result.map(value -> new ReactiveRedisConnection.NumericResponse<ReactiveZSetCommands.ZAggregateStoreCommand, Long>((ReactiveZSetCommands.ZAggregateStoreCommand)command, (Long)value));
        }));
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux<ByteBuffer>>> zRangeByLex(Publisher<ReactiveZSetCommands.ZRangeByLexCommand> commands) {
        return this.connection.execute(reactiveCommands -> Flux.from((Publisher)commands).concatMap(command -> {
            Assert.notNull((Object)command.getKey(), (String)"Destination key must not be null");
            Flux result = !command.getLimit().isUnlimited() ? (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? reactiveCommands.zrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit())) : reactiveCommands.zrevrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange()), LettuceConverters.toLimit(command.getLimit()))) : (ObjectUtils.nullSafeEquals((Object)command.getDirection(), (Object)Sort.Direction.ASC) ? reactiveCommands.zrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange())) : reactiveCommands.zrevrangebylex((Object)command.getKey(), RangeConverter.toRange(command.getRange())));
            return Mono.just(new ReactiveRedisConnection.CommandResponse<ReactiveZSetCommands.ZRangeByLexCommand, Flux>((ReactiveZSetCommands.ZRangeByLexCommand)command, result));
        }));
    }

    private static ZStoreArgs zStoreArgs(@Nullable Aggregate aggregate, @Nullable List<Double> weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        if (weights != null) {
            args.weights(weights.stream().mapToDouble(it -> it).toArray());
        }
        return args;
    }

    private Tuple toTuple(ScoredValue<ByteBuffer> scoredValue) {
        return (Tuple)scoredValue.map(it -> new DefaultTuple(ByteUtils.getBytes(it), scoredValue.getScore())).getValue();
    }

    private Tuple toTuple(ByteBuffer value, double score) {
        return new DefaultTuple(ByteUtils.getBytes(value), score);
    }

    protected LettuceReactiveRedisConnection getConnection() {
        return this.connection;
    }
}

