/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.data.redis.core.index.IndexDefinition;
import org.springframework.data.redis.core.index.IndexValueTransformer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class RedisIndexDefinition
implements IndexDefinition {
    private final String keyspace;
    private final String indexName;
    @Nullable
    private final String path;
    private final List<IndexDefinition.Condition<?>> conditions;
    @Nullable
    private IndexValueTransformer valueTransformer;

    protected RedisIndexDefinition(String keyspace, @Nullable String path, String indexName) {
        this.keyspace = keyspace;
        this.indexName = indexName;
        this.path = path;
        this.conditions = new ArrayList();
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    @Override
    public Collection<IndexDefinition.Condition<?>> getConditions() {
        return Collections.unmodifiableCollection(this.conditions);
    }

    @Override
    public IndexValueTransformer valueTransformer() {
        return this.valueTransformer != null ? this.valueTransformer : NoOpValueTransformer.INSTANCE;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    protected void addCondition(IndexDefinition.Condition<?> condition) {
        Assert.notNull(condition, (String)"Condition must not be null");
        this.conditions.add(condition);
    }

    public void setValueTransformer(IndexValueTransformer valueTransformer) {
        this.valueTransformer = valueTransformer;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.indexName);
        return result + ObjectUtils.nullSafeHashCode((Object)this.keyspace);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedisIndexDefinition)) {
            return false;
        }
        RedisIndexDefinition that = (RedisIndexDefinition)obj;
        if (!ObjectUtils.nullSafeEquals((Object)this.keyspace, (Object)that.keyspace)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.indexName, (Object)that.indexName);
    }

    public static enum NoOpValueTransformer implements IndexValueTransformer
    {
        INSTANCE;


        public Object convert(Object source) {
            return source;
        }
    }

    public static class PathCondition
    implements IndexDefinition.Condition<Object> {
        private final String path;

        public PathCondition(String path) {
            this.path = path;
        }

        @Override
        public boolean matches(Object value, IndexDefinition.IndexingContext context) {
            if (!StringUtils.hasText((String)this.path)) {
                return true;
            }
            return ObjectUtils.nullSafeEquals((Object)context.getPath(), (Object)this.path);
        }
    }

    public static class OrCondition<T>
    implements IndexDefinition.Condition<T> {
        private final List<IndexDefinition.Condition<T>> conditions = new ArrayList<IndexDefinition.Condition<T>>();

        public OrCondition(Collection<IndexDefinition.Condition<T>> conditions) {
            this.conditions.addAll(conditions);
        }

        @Override
        public boolean matches(T value, IndexDefinition.IndexingContext context) {
            for (IndexDefinition.Condition<T> condition : this.conditions) {
                if (!condition.matches(value, context)) continue;
                return true;
            }
            return false;
        }
    }

    public static class CompositeValueTransformer
    implements IndexValueTransformer {
        private final List<IndexValueTransformer> transformers = new ArrayList<IndexValueTransformer>();

        public CompositeValueTransformer(Collection<IndexValueTransformer> transformers) {
            this.transformers.addAll(transformers);
        }

        public Object convert(Object source) {
            Object tmp = source;
            for (IndexValueTransformer transformer : this.transformers) {
                tmp = transformer.convert(tmp);
            }
            return tmp;
        }
    }

    public static enum LowercaseIndexValueTransformer implements IndexValueTransformer
    {
        INSTANCE;


        public Object convert(Object source) {
            if (!(source instanceof String)) {
                return source;
            }
            String string = (String)source;
            return string.toLowerCase();
        }
    }
}

