/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ScoredValueScanCursor;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZAggregateArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.async.RedisSortedSetAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class LettuceZSetCommands
implements RedisZSetCommands {
    private final LettuceConnection connection;

    LettuceZSetCommands(LettuceConnection connection) {
        this.connection = connection;
    }

    @Override
    public Boolean zAdd(byte[] key, double score, byte[] value, RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.connection.invoke().from(RedisSortedSetAsyncCommands::zadd, key, LettuceZSetCommands.toZAddArgs(args), score, value).get(LettuceConverters.longToBoolean());
    }

    @Override
    public Long zAdd(byte[] key, Set<RedisZSetCommands.Tuple> tuples, RedisZSetCommands.ZAddArgs args) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zadd, key, LettuceZSetCommands.toZAddArgs(args), LettuceConverters.toObjects(tuples).toArray());
    }

    @Override
    public Long zRem(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Values must not be null!");
        Assert.noNullElements((Object[])values, (String)"Values must not contain null elements!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zrem, key, values);
    }

    @Override
    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Double)this.connection.invoke().just(RedisSortedSetAsyncCommands::zincrby, key, increment, value);
    }

    @Override
    public byte[] zRandMember(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.connection.invoke().just(RedisSortedSetAsyncCommands::zrandmember, key);
    }

    @Override
    public List<byte[]> zRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.connection.invoke().just(RedisSortedSetAsyncCommands::zrandmember, key, count);
    }

    @Override
    public RedisZSetCommands.Tuple zRandMemberWithScore(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (RedisZSetCommands.Tuple)this.connection.invoke().from(RedisSortedSetAsyncCommands::zrandmemberWithScores, key).get(LettuceConverters::toTuple);
    }

    @Override
    public List<RedisZSetCommands.Tuple> zRandMemberWithScore(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrandmemberWithScores, key, count).toList(LettuceConverters::toTuple);
    }

    @Override
    public Long zRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zrank, key, value);
    }

    @Override
    public Long zRevRank(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zrevrank, key, value);
    }

    @Override
    public Set<byte[]> zRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrange, key, start, end).toSet();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangeWithScores, key, start, end).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        if (limit.isUnlimited()) {
            return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebyscoreWithScores, key, LettuceConverters.toRange(range)).toSet(LettuceConverters::toTuple);
        }
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebyscoreWithScores, key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrange, key, start, end).toSet(Converters.identityConverter());
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangeWithScores, key, start, end).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Set<byte[]> zRevRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        if (limit.isUnlimited()) {
            return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangebyscore, key, LettuceConverters.toRange(range)).toSet();
        }
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangebyscore, key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)).toSet();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zRevRangeByScoreWithScores(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYSCOREWITHSCORES must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        if (limit.isUnlimited()) {
            return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangebyscoreWithScores, key, LettuceConverters.toRange(range)).toSet(LettuceConverters::toTuple);
        }
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangebyscoreWithScores, key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Long zCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zcount, key, LettuceConverters.toRange(range));
    }

    @Override
    public Long zLexCount(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zlexcount, key, LettuceConverters.toRange(range, true));
    }

    @Override
    @Nullable
    public RedisZSetCommands.Tuple zPopMin(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (RedisZSetCommands.Tuple)this.connection.invoke().from(RedisSortedSetAsyncCommands::zpopmin, key).get(LettuceConverters::toTuple);
    }

    @Override
    @Nullable
    public Set<RedisZSetCommands.Tuple> zPopMin(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zpopmin, key, count).toSet(LettuceConverters::toTuple);
    }

    @Override
    @Nullable
    public RedisZSetCommands.Tuple bZPopMin(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null!");
        if (TimeUnit.MILLISECONDS == unit) {
            return (RedisZSetCommands.Tuple)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from((rec$, x$0, xva$1) -> rec$.bzpopmin(x$0, (Object[])new byte[][]{xva$1}), TimeoutUtils.toDoubleSeconds(timeout, unit), key).get(it -> (RedisZSetCommands.Tuple)it.map(LettuceConverters::toTuple).getValueOrElse(null));
        }
        return (RedisZSetCommands.Tuple)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from((rec$, x$0, xva$1) -> rec$.bzpopmin(x$0, (Object[])new byte[][]{xva$1}), unit.toSeconds(timeout), key).get(it -> (RedisZSetCommands.Tuple)it.map(LettuceConverters::toTuple).getValueOrElse(null));
    }

    @Override
    @Nullable
    public RedisZSetCommands.Tuple zPopMax(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (RedisZSetCommands.Tuple)this.connection.invoke().from(RedisSortedSetAsyncCommands::zpopmax, key).get(LettuceConverters::toTuple);
    }

    @Override
    @Nullable
    public Set<RedisZSetCommands.Tuple> zPopMax(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zpopmax, key, count).toSet(LettuceConverters::toTuple);
    }

    @Override
    @Nullable
    public RedisZSetCommands.Tuple bZPopMax(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null!");
        if (TimeUnit.MILLISECONDS == unit) {
            return (RedisZSetCommands.Tuple)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from((rec$, x$0, xva$1) -> rec$.bzpopmax(x$0, (Object[])new byte[][]{xva$1}), TimeoutUtils.toDoubleSeconds(timeout, unit), key).get(it -> (RedisZSetCommands.Tuple)it.map(LettuceConverters::toTuple).getValueOrElse(null));
        }
        return (RedisZSetCommands.Tuple)this.connection.invoke(this.connection.getAsyncDedicatedConnection()).from((rec$, x$0, xva$1) -> rec$.bzpopmax(x$0, (Object[])new byte[][]{xva$1}), unit.toSeconds(timeout), key).get(it -> (RedisZSetCommands.Tuple)it.map(LettuceConverters::toTuple).getValueOrElse(null));
    }

    @Override
    public Long zCard(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zcard, key);
    }

    @Override
    public Double zScore(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return (Double)this.connection.invoke().just(RedisSortedSetAsyncCommands::zscore, key, value);
    }

    @Override
    public List<Double> zMScore(byte[] key, byte[][] values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)values, (String)"Value must not be null!");
        return (List)this.connection.invoke().just(RedisSortedSetAsyncCommands::zmscore, key, values);
    }

    @Override
    public Long zRemRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zremrangebyrank, key, start, end);
    }

    @Override
    public Long zRemRangeByLex(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range must not be null for ZREMRANGEBYLEX!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zremrangebylex, key, LettuceConverters.toRange(range, true));
    }

    @Override
    public Long zRemRangeByScore(byte[] key, RedisZSetCommands.Range range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREMRANGEBYSCORE must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zremrangebyscore, key, LettuceConverters.toRange(range));
    }

    @Override
    public Set<byte[]> zDiff(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zdiff, sets).toSet();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zDiffWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zdiffWithScores, sets).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Long zDiffStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zdiffstore, destKey, sets);
    }

    @Override
    public Set<byte[]> zInter(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zinter, sets).toSet();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zInterWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zinterWithScores, sets).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zInterWithScores(RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZAggregateArgs zAggregateArgs = LettuceZSetCommands.zAggregateArgs(aggregate, weights);
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zinterWithScores, zAggregateArgs, sets).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Long zInterStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZStoreArgs storeArgs = LettuceZSetCommands.zStoreArgs(aggregate, weights);
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zinterstore, destKey, storeArgs, sets);
    }

    @Override
    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zinterstore, destKey, sets);
    }

    @Override
    public Set<byte[]> zUnion(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zunion, sets).toSet();
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zUnionWithScores(byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zunionWithScores, sets).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Set<RedisZSetCommands.Tuple> zUnionWithScores(RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)sets, (String)"Sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZAggregateArgs zAggregateArgs = LettuceZSetCommands.zAggregateArgs(aggregate, weights);
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zunionWithScores, zAggregateArgs, sets).toSet(LettuceConverters::toTuple);
    }

    @Override
    public Long zUnionStore(byte[] destKey, RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        Assert.isTrue((weights.size() == sets.length ? 1 : 0) != 0, () -> String.format("The number of weights (%d) must match the number of source sets (%d)!", weights.size(), sets.length));
        ZStoreArgs storeArgs = LettuceZSetCommands.zStoreArgs(aggregate, weights);
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zunionstore, destKey, storeArgs, sets);
    }

    @Override
    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)sets, (String)"Source sets must not be null!");
        Assert.noNullElements((Object[])sets, (String)"Source sets must not contain null elements!");
        return (Long)this.connection.invoke().just(RedisSortedSetAsyncCommands::zunionstore, destKey, sets);
    }

    @Override
    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, ScanOptions options) {
        return this.zScan(key, 0L, options);
    }

    public Cursor<RedisZSetCommands.Tuple> zScan(byte[] key, long cursorId, ScanOptions options) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return new KeyBoundCursor<RedisZSetCommands.Tuple>(key, cursorId, options){

            @Override
            protected ScanIteration<RedisZSetCommands.Tuple> doScan(byte[] key, long cursorId, ScanOptions options) {
                if (LettuceZSetCommands.this.connection.isQueueing() || LettuceZSetCommands.this.connection.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ScanCursor scanCursor = LettuceZSetCommands.this.connection.getScanCursor(cursorId);
                ScanArgs scanArgs = LettuceConverters.toScanArgs(options);
                ScoredValueScanCursor scoredValueScanCursor = (ScoredValueScanCursor)LettuceZSetCommands.this.connection.invoke().just(RedisSortedSetAsyncCommands::zscan, key, scanCursor, scanArgs);
                String nextCursorId = scoredValueScanCursor.getCursor();
                List result = scoredValueScanCursor.getValues();
                List values = (List)LettuceZSetCommands.this.connection.failsafeReadScanValues(result, LettuceConverters.scoredValuesToTupleList());
                return new ScanIteration<RedisZSetCommands.Tuple>(Long.valueOf(nextCursorId), values);
            }

            @Override
            protected void doClose() {
                LettuceZSetCommands.this.connection.close();
            }
        }.open();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebyscore, key, min, max).toSet();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebyscore, key, min, max, offset, count).toSet();
    }

    @Override
    public Set<byte[]> zRangeByScore(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYSCORE must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        if (limit.isUnlimited()) {
            return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebyscore, key, LettuceConverters.toRange(range)).toSet();
        }
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebyscore, key, LettuceConverters.toRange(range), LettuceConverters.toLimit(limit)).toSet();
    }

    @Override
    public Set<byte[]> zRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZRANGEBYLEX must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        if (limit.isUnlimited()) {
            return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebylex, key, LettuceConverters.toRange(range, true)).toSet();
        }
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrangebylex, key, LettuceConverters.toRange(range, true), LettuceConverters.toLimit(limit)).toSet();
    }

    @Override
    public Set<byte[]> zRevRangeByLex(byte[] key, RedisZSetCommands.Range range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)range, (String)"Range for ZREVRANGEBYLEX must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        if (limit.isUnlimited()) {
            return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangebylex, key, LettuceConverters.toRange(range, true)).toSet();
        }
        return this.connection.invoke().fromMany(RedisSortedSetAsyncCommands::zrevrangebylex, key, LettuceConverters.toRange(range, true), LettuceConverters.toLimit(limit)).toSet();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    private static ZStoreArgs zStoreArgs(@Nullable RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        ZStoreArgs args = new ZStoreArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        args.weights(weights.toArray());
        return args;
    }

    private static ZAggregateArgs zAggregateArgs(@Nullable RedisZSetCommands.Aggregate aggregate, RedisZSetCommands.Weights weights) {
        ZAggregateArgs args = new ZAggregateArgs();
        if (aggregate != null) {
            switch (aggregate) {
                case MIN: {
                    args.min();
                    break;
                }
                case MAX: {
                    args.max();
                    break;
                }
                default: {
                    args.sum();
                }
            }
        }
        args.weights(weights.toArray());
        return args;
    }

    private static ZAddArgs toZAddArgs(RedisZSetCommands.ZAddArgs source) {
        ZAddArgs target = new ZAddArgs();
        if (!source.isEmpty()) {
            return target;
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.XX)) {
            target.xx();
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.NX)) {
            target.nx();
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.GT)) {
            target.gt();
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.LT)) {
            target.lt();
        }
        if (source.contains(RedisZSetCommands.ZAddArgs.Flag.CH)) {
            target.ch();
        }
        return target;
    }
}

