/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.util;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;

public abstract class DecodeUtils {
    public static String decode(byte[] bytes) {
        return new String(Base64.getDecoder().decode(bytes));
    }

    public static String[] decodeMultiple(byte[] ... bytes) {
        String[] result = new String[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = DecodeUtils.decode(bytes[i]);
        }
        return result;
    }

    @Nullable
    public static byte[] encode(@Nullable String string) {
        return string == null ? null : Base64.getEncoder().encode(string.getBytes());
    }

    public static Map<byte[], byte[]> encodeMap(Map<String, byte[]> map) {
        LinkedHashMap<byte[], byte[]> result = new LinkedHashMap<byte[], byte[]>(map.size());
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            result.put(DecodeUtils.encode(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Map<String, byte[]> decodeMap(Map<byte[], byte[]> tuple) {
        LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>(tuple.size());
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            result.put(DecodeUtils.decode(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public static Set<byte[]> convertToSet(Collection<String> keys) {
        LinkedHashSet<byte[]> set = new LinkedHashSet<byte[]>(keys.size());
        for (String string : keys) {
            set.add(DecodeUtils.encode(string));
        }
        return set;
    }

    public static List<byte[]> convertToList(Collection<String> keys) {
        ArrayList<byte[]> set = new ArrayList<byte[]>(keys.size());
        for (String string : keys) {
            set.add(DecodeUtils.encode(string));
        }
        return set;
    }
}

